/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import com.intel.stl.api.Utils;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDCableInfoBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static Logger log = LoggerFactory.getLogger(DDCableInfoBean.class);
    private byte id;
    private String vendorName;
    private byte[] vendorOui;
    private String vendorPn;
    private String vendorRev;
    private String vendorSN;
    private String dateCode;
    private Date date;
    private double maxPower;
    private short cableLength;
    private byte connector;
    private byte xmitTech;

    public byte getId() {
        return this.id;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public byte[] getVendorOui() {
        return this.vendorOui;
    }

    public String getVendorPn() {
        return this.vendorPn;
    }

    public String getVendorRev() {
        return this.vendorRev;
    }

    public String getVendorSN() {
        return this.vendorSN;
    }

    public String getDateCode() {
        return this.dateCode;
    }

    public Date getDate() {
        return this.date;
    }

    public double getMaxPower() {
        return this.maxPower;
    }

    public short getCableLength() {
        return this.cableLength;
    }

    public byte getConnector() {
        return this.connector;
    }

    public byte getXmitTech() {
        return this.xmitTech;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public void setVendorOui(byte[] vendorOui) {
        this.vendorOui = vendorOui;
    }

    public void setVendorPn(String vendorPn) {
        this.vendorPn = vendorPn;
    }

    public void setVendorRev(String vendorRev) {
        this.vendorRev = vendorRev;
    }

    public void setVendorSN(String vendorSN) {
        this.vendorSN = vendorSN;
    }

    public void setDateCode(String year, String month, String day, String lot) {
        this.dateCode = year + "/" + month + "/" + day + "-" + lot;
        SimpleDateFormat formatter = null;
        formatter = lot == null || lot.isEmpty() ? new SimpleDateFormat("yy/MM/dd-") : new SimpleDateFormat("yy/MM/dd-hh");
        try {
            this.date = formatter.parse(this.dateCode);
        }
        catch (ParseException e) {
            this.date = null;
            log.warn("Parsing exception for date code string", (Throwable)e);
        }
    }

    public void setDateCode(String dateCode) {
        this.dateCode = dateCode;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setMaxPower(byte maxPower) {
        this.maxPower = (double)Utils.unsignedByte(maxPower) * 0.25;
    }

    public void setCableLength(byte cableLength) {
        this.cableLength = Utils.unsignedByte(cableLength);
    }

    public void setConnector(byte connector) {
        this.connector = connector;
    }

    public void setXmitTech(byte xmitTech) {
        this.xmitTech = xmitTech;
    }

    public String toString() {
        return "DDCableInfoBean [id=" + this.id + ", vendorName=" + this.vendorName + ", vendorOui=" + Arrays.toString(this.vendorOui) + ", vendorPn=" + this.vendorPn + ", vendorRev=" + this.vendorRev + ", vendorSN=" + this.vendorSN + ", dateCode=" + this.dateCode + ", date=" + this.date + ", maxPower=" + this.maxPower + ", cableLength=" + this.cableLength + ", connector=" + this.connector + ", xmitTech=" + this.xmitTech + "]";
    }
}

