/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PowerClassType {
    CLASS1(0, 0),
    CLASS2(0, 1),
    CLASS3(0, 2),
    CLASS4(0, 3),
    CLASS5(1),
    CLASS6(2),
    CLASS7(3),
    UNDEFINED(-1);

    private final int codeHigh;
    private int codeLow;
    private static Logger log;

    private PowerClassType(int codeHigh, int codeLow) {
        this.codeHigh = codeHigh;
        this.codeLow = codeLow;
    }

    private PowerClassType(int codeHigh) {
        this.codeHigh = codeHigh;
    }

    public int getCodeHigh() {
        return this.codeHigh;
    }

    public int getCodeLow() {
        return this.codeLow;
    }

    public static PowerClassType getPowerClassType(int codeHigh, int codeLow) {
        for (PowerClassType pc : PowerClassType.values()) {
            if (pc.getCodeHigh() != codeHigh || pc.getCodeLow() != codeLow) continue;
            return pc;
        }
        log.error("Undefined PowerClassType : codeHigh ='" + codeHigh + "'" + ", codeLow ='" + codeLow + "'");
        return UNDEFINED;
    }

    static {
        log = LoggerFactory.getLogger(PowerClassType.class);
    }
}

