/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.SubnetException;
import com.intel.stl.api.subnet.impl.NodeCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.configuration.BaseCache;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.datamanager.DatabaseManager;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class DBNodeCacheImpl
extends BaseCache
implements NodeCache {
    private final DatabaseManager dbMgr;
    private final SAHelper helper;
    private final AtomicReference<EnumMap<NodeType, Integer>> activeNodesTypeDist;

    public DBNodeCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.dbMgr = cacheMgr.getDatabaseManager();
        this.helper = cacheMgr.getSAHelper();
        this.activeNodesTypeDist = new AtomicReference<Object>(null);
    }

    @Override
    public List<NodeRecordBean> getNodes(boolean includeInactive) throws SubnetDataNotFoundException {
        ArrayList<NodeRecordBean> res = new ArrayList<NodeRecordBean>();
        try {
            List<NodeRecordBean> nodes = this.dbMgr.getNodes(this.getSubnetName());
            if (nodes != null && !nodes.isEmpty()) {
                for (NodeRecordBean node : nodes) {
                    if (!includeInactive && !node.isActive()) continue;
                    res.add(node);
                }
            }
        }
        catch (DatabaseException e) {
            log.error("Received a database exception while getting all nodes", (Throwable)e);
            throw SubnetApi.getSubnetException(e);
        }
        return res;
    }

    @Override
    public NodeRecordBean getNode(int lid) throws SubnetDataNotFoundException {
        SubnetDataNotFoundException ne = null;
        try {
            return this.dbMgr.getNode(this.getSubnetName(), lid);
        }
        catch (DatabaseException e) {
            log.error("Received a database exception while getting a node with lid " + lid, (Throwable)e);
            throw SubnetApi.getSubnetException(e);
        }
        catch (SubnetDataNotFoundException e) {
            ne = e;
            log.info("Couldn't find node lid=" + lid + "  from database");
            NodeRecordBean node = null;
            try {
                node = this.helper.getNode(lid);
            }
            catch (Exception exception) {
                SubnetException se = SubnetApi.getSubnetException(exception);
                log.error("Error while getting node with lid=" + lid + " from Fabric", (Throwable)exception);
                throw se;
            }
            if (node != null) {
                this.activeNodesTypeDist.set(null);
                this.cacheMgr.startTopologyUpdateTask();
                return node;
            }
            throw ne;
        }
    }

    @Override
    public NodeRecordBean getNode(long portGuid) throws SubnetDataNotFoundException {
        SubnetDataNotFoundException ne = null;
        try {
            return this.dbMgr.getNodeByPortGUID(this.getSubnetName(), portGuid);
        }
        catch (DatabaseException e) {
            log.error("Received a database exception while getting a node with port Guid " + portGuid, (Throwable)e);
            throw SubnetApi.getSubnetException(e);
        }
        catch (SubnetDataNotFoundException e) {
            ne = e;
            log.info("Couldn't find node guid=" + StringUtils.longHexString(portGuid) + "  from database");
            NodeRecordBean node = null;
            try {
                node = this.helper.getNode(portGuid);
            }
            catch (Exception exception) {
                SubnetException se = SubnetApi.getSubnetException(exception);
                log.error("Error while getting node with portGuid=" + portGuid + " from Fabric", (Throwable)exception);
                throw se;
            }
            if (node != null) {
                this.activeNodesTypeDist.set(null);
                this.cacheMgr.startTopologyUpdateTask();
                return node;
            }
            throw ne;
        }
    }

    @Override
    public EnumMap<NodeType, Integer> getNodesTypeDist(boolean includeInactive, boolean refresh) throws SubnetDataNotFoundException {
        if (includeInactive) {
            return this.getNodesTypeDist();
        }
        return this.getActiveNodesTypeDist(refresh);
    }

    protected EnumMap<NodeType, Integer> getNodesTypeDist() throws SubnetDataNotFoundException {
        try {
            return this.dbMgr.getNodeTypeDist(this.getSubnetName());
        }
        catch (DatabaseException e) {
            log.error("Received a database exception while getting a node type distribution", (Throwable)e);
            throw SubnetApi.getSubnetException(e);
        }
    }

    protected EnumMap<NodeType, Integer> getActiveNodesTypeDist(boolean refresh) throws SubnetDataNotFoundException {
        if (refresh || this.activeNodesTypeDist.get() == null) {
            List<NodeRecordBean> nodes = this.getNodes(false);
            EnumMap<NodeType, Integer> nodesTypeDistMap = new EnumMap<NodeType, Integer>(NodeType.class);
            for (NodeRecordBean node : nodes) {
                NodeType type;
                if (!node.isActive()) continue;
                Integer count = (Integer)nodesTypeDistMap.get((Object)(type = node.getNodeType()));
                nodesTypeDistMap.put(type, count == null ? 1 : count + 1);
            }
            this.activeNodesTypeDist.set(nodesTypeDistMap);
        }
        return this.activeNodesTypeDist.get();
    }

    private String getSubnetName() {
        return this.helper.getSubnetDescription().getName();
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean refreshCache() {
        this.activeNodesTypeDist.set(null);
        return true;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        this.activeNodesTypeDist.set(null);
        return true;
    }
}

