/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.NodeInfoBean;
import com.intel.stl.api.subnet.NodeRecordBean;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.api.subnet.SubnetDataNotFoundException;
import com.intel.stl.api.subnet.impl.NodeCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class NodeCacheImpl
extends MemoryCache<Map<Integer, NodeRecordBean>>
implements NodeCache {
    private final AtomicReference<EnumMap<NodeType, Integer>> nodesTypeDist;
    private final AtomicReference<EnumMap<NodeType, Integer>> nodesTypeDist2;
    private final SAHelper helper;

    public NodeCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
        this.nodesTypeDist = new AtomicReference<Object>(null);
        this.nodesTypeDist2 = new AtomicReference<Object>(null);
    }

    @Override
    public List<NodeRecordBean> getNodes(boolean includeInactive) throws SubnetDataNotFoundException {
        Map map = (Map)this.getCachedObject();
        ArrayList<NodeRecordBean> res = new ArrayList<NodeRecordBean>();
        if (map != null && !map.isEmpty()) {
            for (NodeRecordBean node : map.values()) {
                if (!includeInactive && !node.isActive()) continue;
                res.add(node);
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        throw new SubnetDataNotFoundException(STLMessages.STL30061_NODE_NOT_FOUND_CACHE_ALL);
    }

    @Override
    public NodeRecordBean getNode(int lid) throws SubnetDataNotFoundException {
        NodeRecordBean node;
        Map nodeMap = (Map)this.getCachedObject();
        if (nodeMap != null && !nodeMap.isEmpty() && (node = (NodeRecordBean)nodeMap.get(lid)) != null) {
            return node;
        }
        log.info("Couldn't find node lid=" + StringUtils.longHexString(lid) + "  from cache");
        node = null;
        try {
            node = this.helper.getNode(lid);
        }
        catch (Exception e) {
            log.error("Error while getting node with lid=" + lid + " from Fabric", (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        if (node != null) {
            this.setCacheReady(false);
            return node;
        }
        throw new SubnetDataNotFoundException((IMessage)STLMessages.STL30055_NODE_NOT_FOUND_IN_CACHE_LID, lid);
    }

    @Override
    public NodeRecordBean getNode(long portGuid) throws SubnetDataNotFoundException {
        Map nodeMap = (Map)this.getCachedObject();
        if (nodeMap != null && !nodeMap.isEmpty()) {
            Collection nodes = nodeMap.values();
            for (NodeRecordBean node : nodes) {
                if (node.getNodeInfo().getPortGUID() != portGuid) continue;
                return node;
            }
        }
        log.info("Couldn't find node guid=" + StringUtils.longHexString(portGuid) + "  from cache");
        NodeRecordBean node = null;
        try {
            node = this.helper.getNode(portGuid);
        }
        catch (Exception e) {
            log.error("Error while getting node with portGuid=" + portGuid + " from Fabric", (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
        if (node != null) {
            this.setCacheReady(false);
            return node;
        }
        throw new SubnetDataNotFoundException((IMessage)STLMessages.STL30056_NODE_NOT_FOUND_IN_CACHE_PORT_GUID, portGuid);
    }

    @Override
    public EnumMap<NodeType, Integer> getNodesTypeDist(boolean includeInactive, boolean refresh) throws SubnetDataNotFoundException {
        if (includeInactive) {
            return this.getNodesTypeDist(refresh);
        }
        return this.getActiveNodesTypeDist(refresh);
    }

    protected EnumMap<NodeType, Integer> getActiveNodesTypeDist(boolean refresh) throws SubnetDataNotFoundException {
        if (refresh || this.nodesTypeDist.get() == null) {
            Map nodeMap = (Map)this.getCachedObject();
            if (nodeMap != null && !nodeMap.isEmpty()) {
                EnumMap<NodeType, Integer> nodesTypeDistMap = new EnumMap<NodeType, Integer>(NodeType.class);
                Collection nodes = nodeMap.values();
                for (NodeRecordBean node : nodes) {
                    NodeType type;
                    if (!node.isActive()) continue;
                    Integer count = (Integer)nodesTypeDistMap.get((Object)(type = node.getNodeType()));
                    nodesTypeDistMap.put(type, count == null ? 1 : count + 1);
                }
                this.nodesTypeDist.set(nodesTypeDistMap);
            } else {
                throw new SubnetDataNotFoundException(STLMessages.STL30057_NODE_TYPE_DIST_FOUND_IN_CACHE);
            }
        }
        return this.nodesTypeDist.get();
    }

    protected EnumMap<NodeType, Integer> getNodesTypeDist(boolean refresh) throws SubnetDataNotFoundException {
        if (refresh || this.nodesTypeDist2.get() == null) {
            Map nodeMap = (Map)this.getCachedObject();
            if (nodeMap != null && !nodeMap.isEmpty()) {
                EnumMap<NodeType, Integer> nodesTypeDistMap = new EnumMap<NodeType, Integer>(NodeType.class);
                Collection nodes = nodeMap.values();
                for (NodeRecordBean node : nodes) {
                    NodeType type;
                    Integer count = (Integer)nodesTypeDistMap.get((Object)(type = node.getNodeType()));
                    nodesTypeDistMap.put(type, count == null ? 1 : count + 1);
                }
                this.nodesTypeDist2.set(nodesTypeDistMap);
            } else {
                throw new SubnetDataNotFoundException(STLMessages.STL30057_NODE_TYPE_DIST_FOUND_IN_CACHE);
            }
        }
        return this.nodesTypeDist2.get();
    }

    @Override
    protected Map<Integer, NodeRecordBean> retrieveObjectForCache() throws Exception {
        List<NodeRecordBean> nodes = this.helper.getNodes();
        log.info("Retrieve " + (nodes == null ? 0 : nodes.size()) + " nodes from FE");
        HashMap<Integer, NodeRecordBean> map = null;
        if (nodes != null) {
            map = new HashMap<Integer, NodeRecordBean>();
            for (NodeRecordBean node : nodes) {
                map.put(node.getLid(), node);
            }
        }
        this.nodesTypeDist.set(null);
        this.nodesTypeDist2.set(null);
        return map;
    }

    @Override
    public void reset() {
        super.reset();
        this.updateCache();
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        Map nodeMap = (Map)this.getCachedObject();
        if (nodeMap == null) {
            log.info("Node map is null");
            return false;
        }
        switch (notice.getTrapType()) {
            case GID_NOW_IN_SERVICE: {
                this.resetNode(notice, true);
                break;
            }
            case GID_OUT_OF_SERVICE: {
                this.resetNode(notice, false);
            }
        }
        this.nodesTypeDist.set(null);
        this.nodesTypeDist2.set(null);
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }

    private void resetNode(NoticeProcess notice, boolean status) {
        Map nodeMap = (Map)this.getCachedObject();
        int lid = notice.getLid();
        NodeRecordBean node = (NodeRecordBean)nodeMap.get(lid);
        NodeRecordBean newNode = notice.getNode();
        if (node != null && newNode != null) {
            NodeInfoBean nodeInfo = node.getNodeInfo();
            NodeInfoBean newNodeInfo = newNode.getNodeInfo();
            if (nodeInfo.getNodeGUID() != newNodeInfo.getNodeGUID()) {
                log.info("Node GUID in cache does not match GUID in FM");
                this.setCacheReady(false);
            }
            node.setActive(status);
        } else if (node == null) {
            if (newNode != null) {
                newNode.setActive(status);
                nodeMap.put(lid, newNode);
            } else {
                log.error("Notice for node with lid " + lid + " to set active status to " + status + " but no node from subnet");
            }
        } else {
            node.setActive(false);
        }
    }
}

