/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.api.subnet.impl;

import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.subnet.SwitchRecordBean;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SubnetApi;
import com.intel.stl.api.subnet.impl.SwitchCache;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.MemoryCache;
import java.util.List;

public class SwitchCacheImpl
extends MemoryCache<List<SwitchRecordBean>>
implements SwitchCache {
    private final SAHelper helper;

    public SwitchCacheImpl(CacheManager cacheMgr) {
        super(cacheMgr);
        this.helper = cacheMgr.getSAHelper();
    }

    @Override
    public List<SwitchRecordBean> getSwitches() {
        List res = (List)this.getCachedObject();
        return res;
    }

    @Override
    public SwitchRecordBean getSwitch(int lid) {
        List<SwitchRecordBean> switches = this.getSwitches();
        if (switches != null) {
            for (SwitchRecordBean switchNode : switches) {
                if (switchNode.getLid() != lid) continue;
                return switchNode;
            }
        }
        try {
            SwitchRecordBean sw = this.helper.getSwitch(lid);
            if (sw != null) {
                this.setCacheReady(false);
            }
            return sw;
        }
        catch (Exception e) {
            log.error("Error getting switch by lid " + lid, (Throwable)e);
            e.printStackTrace();
            throw SubnetApi.getSubnetException(e);
        }
    }

    @Override
    protected List<SwitchRecordBean> retrieveObjectForCache() throws Exception {
        List<SwitchRecordBean> res = this.helper.getSwitches();
        log.info("Retrieve " + (res == null ? 0 : res.size()) + " switches from FE");
        return res;
    }

    @Override
    public boolean refreshCache(NoticeProcess notice) throws Exception {
        return true;
    }

    @Override
    protected RuntimeException processRefreshCacheException(Exception e) {
        return SubnetApi.getSubnetException(e);
    }
}

