/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.common;

import com.intel.stl.common.STLMessages;
import com.intel.stl.common.SystemFunctions;
import com.intel.stl.common.SystemFunctionsImpl;
import com.intel.stl.configuration.AppSettings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AppDataUtils {
    private static Logger log;
    private static final boolean DEBUG_LOGGING = false;
    protected static final String INTEL_NAME = "Intel";
    protected static final String APPLICATION_NAME = "FabricManagerGUI";
    protected static final String CONFIGURATION_URL = "/com/intel/stl/configuration/";
    private static final String DATABASE_FOLDER_NAME = "db";
    private static final String LOGS_FOLDER_NAME = "logs";
    private static final String UTIL_FOLDER_NAME = "util";
    private static final String APPLICATION_SETTINGS_FILE = "settings.xml";
    private static final String DEFAULT_USEROPTIONS_FILE = "defaultuseroptions.xml";
    public static final String LOGCONFIG_FILE = "logconfig.xml";
    protected static final String LOCK_FILE = "FabricManagerGUI.lock";
    public static final String FM_GUI_DIR = "fmgui.logs.dir";
    public static final String LOGBACK_CONFIGFILE = "logback.configurationFile";
    protected static final String APPDATA_STR = "APPDATA";
    protected static SystemFunctions sysfunctions;

    public static String getIntelDataPath() {
        String appDataPath = "";
        String osName = sysfunctions.getSystemProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") != -1) {
            appDataPath = sysfunctions.getEnvironmentVariable(APPDATA_STR);
            String osmaj = sysfunctions.getSystemProperty("os.version").split("\\.")[0];
            int osver = Integer.parseInt(osmaj);
            if (osver >= 5) {
                appDataPath = sysfunctions.getEnvironmentVariable(APPDATA_STR) + File.separatorChar + INTEL_NAME;
            }
        } else {
            appDataPath = osName.indexOf("mac") != -1 ? sysfunctions.getSystemProperty("user.home") + File.separatorChar + "Library" + File.separatorChar + INTEL_NAME : sysfunctions.getSystemProperty("user.home") + File.separatorChar + "." + INTEL_NAME;
        }
        return appDataPath;
    }

    public static void createIntelDataFolder() {
        AppDataUtils.createFolder(AppDataUtils.getIntelDataPath());
    }

    public static String getApplicationDataPath() {
        return AppDataUtils.getIntelDataPath() + File.separatorChar + APPLICATION_NAME;
    }

    public static void createApplicationDataFolder() {
        AppDataUtils.createFolder(AppDataUtils.getApplicationDataPath());
    }

    public static String getDatabaseDataPath() {
        return AppDataUtils.getApplicationDataPath() + File.separatorChar + DATABASE_FOLDER_NAME;
    }

    public static void createDatabaseDataFolder() {
        AppDataUtils.createFolder(AppDataUtils.getDatabaseDataPath());
    }

    public static String getLogPath() {
        return AppDataUtils.getApplicationDataPath() + File.separatorChar + LOGS_FOLDER_NAME;
    }

    public static void createLogFolder() {
        AppDataUtils.createFolder(AppDataUtils.getLogPath());
    }

    public static String getLogPropertyPath() {
        return AppDataUtils.getApplicationDataPath() + File.separatorChar + LOGCONFIG_FILE;
    }

    public static String getLockFilePath() {
        return AppDataUtils.getApplicationDataPath() + File.separatorChar + LOCK_FILE;
    }

    protected static void createFolder(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    public static AppSettings getApplicationSettings() throws InvalidPropertiesFormatException, IOException {
        return new AppSettings(AppDataUtils.getApplicationSettings(APPLICATION_SETTINGS_FILE, CONFIGURATION_URL, AppDataUtils.getApplicationDataPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties getApplicationSettings(String settingsFilename, String settingsUrl, String settingsLocation) throws InvalidPropertiesFormatException, IOException {
        log = LoggerFactory.getLogger(AppDataUtils.class);
        Properties settings = new Properties();
        URL settingsResource = sysfunctions.getResource(settingsUrl + settingsFilename);
        if (settingsResource == null) {
            return settings;
        }
        InputStream sis = AppDataUtils.class.getResourceAsStream(settingsUrl + settingsFilename);
        try {
            settings.loadFromXML(sis);
        }
        finally {
            try {
                sis.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Properties overrides = AppDataUtils.getCustomSettings(settingsFilename, settingsLocation);
        Set<Object> keys = overrides.keySet();
        for (Object obj : keys) {
            String key = obj.toString().toLowerCase();
            String oldvalue = settings.getProperty(key);
            String newvalue = overrides.getProperty(key);
            if (key.equals("app.intel.path") || key.equals("app.data.path")) {
                log.warn(STLMessages.STL10014_CANNOT_OVERRIDE_SETTING.getDescription(key));
                continue;
            }
            log.warn(STLMessages.STL10015_OVERRIDING_SETTING.getDescription(key, oldvalue, newvalue));
            settings.setProperty(key, newvalue);
        }
        return settings;
    }

    public static Properties getCustomSettings(String settingsLocation) throws InvalidPropertiesFormatException, IOException {
        return AppDataUtils.getCustomSettings(APPLICATION_SETTINGS_FILE, settingsLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties getCustomSettings(String settingsFilename, String settingsLocation) throws InvalidPropertiesFormatException, IOException {
        File settingsFile = new File(settingsLocation + File.separatorChar + settingsFilename);
        Properties customSettings = new Properties();
        if (settingsFile.exists()) {
            FileInputStream ois = new FileInputStream(settingsFile);
            try {
                customSettings.loadFromXML(ois);
            }
            finally {
                try {
                    ((InputStream)ois).close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return customSettings;
    }

    public static void saveCustomSettings(Properties customSettings, String settingsLocation) throws IOException {
        AppDataUtils.saveCustomSettings(customSettings, APPLICATION_SETTINGS_FILE, settingsLocation);
    }

    protected static void saveCustomSettings(Properties customSettings, String settingsFilename, String settingsLocation) throws IOException {
        File settingsFile = new File(settingsLocation + File.separatorChar + settingsFilename);
        try (FileOutputStream fileOut = new FileOutputStream(settingsFile);){
            customSettings.storeToXML(fileOut, "Saved");
        }
    }

    public static void initializeLogging() {
        String logPath;
        AppDataUtils.createIntelDataFolder();
        AppDataUtils.createApplicationDataFolder();
        String appDataPath = AppDataUtils.getApplicationDataPath();
        AppDataUtils.copyLogConfigurationIfNonExistent(LOGCONFIG_FILE, appDataPath, CONFIGURATION_URL);
        try {
            Properties customSettings = AppDataUtils.getCustomSettings(appDataPath);
            logPath = customSettings.getProperty("app.log.folder", AppDataUtils.getLogPath());
        }
        catch (Exception e) {
            AppDataUtils.createLogFolder();
            logPath = AppDataUtils.getLogPath();
        }
        logPath = logPath.replace("\\", "/");
        System.setProperty(FM_GUI_DIR, logPath);
        String log4jFile = AppDataUtils.getLogPropertyPath();
        log4jFile = log4jFile.replace("\\", "/");
        System.setProperty(LOGBACK_CONFIGFILE, log4jFile);
        System.setProperty("org.jboss.logging.provider", "slf4j");
        log = LoggerFactory.getLogger(AppDataUtils.class);
    }

    protected static void copyLogConfigurationIfNonExistent(String log4jPropertiesFilename, String log4PropertiesLocation, String settingsUrl) {
        URL log4jResource;
        File log4jProps = new File(log4PropertiesLocation + File.separatorChar + log4jPropertiesFilename);
        if (!log4jProps.exists() && (log4jResource = sysfunctions.getResource(settingsUrl + log4jPropertiesFilename)) != null) {
            AppDataUtils.copyResourceToFile(log4jResource, log4jProps);
        }
    }

    public static void copyResourceToFile(URL resource, File file) {
        InputStream istream = null;
        StringBuilder contents = new StringBuilder();
        try {
            istream = resource.openStream();
            BufferedReader in = sysfunctions.getReader(istream);
            String line = in.readLine();
            while (line != null) {
                contents.append(line + System.getProperty("line.separator"));
                line = in.readLine();
            }
        }
        catch (IOException e) {
            String errMsg = STLMessages.STL10023_ERROR_READING_RESOURCE.getDescription(resource.getFile(), e.getMessage());
            RuntimeException rte = new RuntimeException(errMsg, e);
            throw rte;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            AppDataUtils.writeFile(file, contents.toString());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void writeFile(File file, String contents) throws IOException {
        try (BufferedWriter output = new BufferedWriter(new FileWriter(file));){
            output.write(contents);
        }
    }

    public static String getDefaultUserOptions() {
        String resourceFile = "/com/intel/stl/configuration/defaultuseroptions.xml";
        try {
            return AppDataUtils.readResourceFile(resourceFile);
        }
        catch (IOException e) {
            String errMsg = STLMessages.STL10023_ERROR_READING_RESOURCE.getDescription(resourceFile, e.getMessage());
            log.error(errMsg, (Throwable)e);
            RuntimeException rte = new RuntimeException(errMsg, e);
            throw rte;
        }
    }

    public static String readResourceFile(String resourceFile) throws IOException {
        URL resourceUrl = sysfunctions.getResource(resourceFile);
        if (resourceUrl != null) {
            try (InputStream istream = null;){
                istream = resourceUrl.openStream();
                BufferedReader in = sysfunctions.getReader(istream);
                String line = in.readLine();
                StringBuffer xmlFile = new StringBuffer();
                while (line != null) {
                    String trimmedLine = line.trim();
                    xmlFile.append(trimmedLine);
                    line = in.readLine();
                }
                String string = xmlFile.toString();
                return string;
            }
        }
        RuntimeException rte = new RuntimeException("Resource file '" + resourceFile + "' not found in classpath.");
        throw rte;
    }

    public static final Element convertToDOM(String xml) throws IOException, ParserConfigurationException, SAXException {
        InputSource sourceXML = new InputSource(new StringReader(xml));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xmlDoc = builder.parse(sourceXML);
        Element ele = xmlDoc.getDocumentElement();
        ele.normalize();
        return ele;
    }

    public static final void prettyXmlPrint(Node xml, OutputStream out) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(xml), new StreamResult(out));
    }

    public static final String getPostSetupScript() {
        String fmguiJarPath = AppDataUtils.getAppInstallPath();
        fmguiJarPath = fmguiJarPath + File.separatorChar + UTIL_FOLDER_NAME + File.separatorChar;
        String postSetupScript = null;
        String osName = sysfunctions.getSystemProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") != -1) {
            postSetupScript = fmguiJarPath + File.separatorChar + "postsetup.bat";
        } else if (osName.indexOf("mac") == -1) {
            postSetupScript = fmguiJarPath + File.separatorChar + "postsetup.sh";
        }
        return postSetupScript;
    }

    public static final boolean isPostSetupNeeded() {
        String fmguiJarPath;
        File origFile;
        String cleanScript;
        boolean needed = true;
        String osName = sysfunctions.getSystemProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") != -1) {
            cleanScript = "fmguiclear.bat";
        } else {
            if (osName.indexOf("mac") != -1) {
                return false;
            }
            cleanScript = "fmguiclear.sh";
        }
        String dataPath = AppDataUtils.getApplicationDataPath();
        File copiedFile = new File(dataPath + File.separatorChar + cleanScript);
        if (copiedFile.exists() && (origFile = new File((fmguiJarPath = AppDataUtils.getAppInstallPath()) + File.separatorChar + UTIL_FOLDER_NAME + File.separatorChar + cleanScript)).exists() && copiedFile.lastModified() == origFile.lastModified()) {
            needed = false;
        }
        return needed;
    }

    private static String getAppInstallPath() {
        String fmguiJarPath = "";
        try {
            fmguiJarPath = sysfunctions.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (fmguiJarPath.endsWith(".jar")) {
                File jarPath = new File(fmguiJarPath);
                fmguiJarPath = jarPath.getParent();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return fmguiJarPath;
    }

    static {
        sysfunctions = new SystemFunctionsImpl();
    }
}

