/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class UTFControl
extends ResourceBundle.Control {
    private static final String PROPERTIES = "properties";
    private final String encoding;

    public UTFControl(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        if (!format.equals("java.properties")) {
            throw new IllegalArgumentException("Bundle format '" + format + "' not supported by this ResourceBundle Control");
        }
        PropertyResourceBundle bundle = null;
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, PROPERTIES);
        InputStream stream = this.createInputStream(resourceName, loader, reload);
        if (stream != null) {
            try {
                InputStreamReader reader = new InputStreamReader(stream, this.encoding);
                bundle = new PropertyResourceBundle(reader);
            }
            finally {
                stream.close();
            }
        }
        return bundle;
    }

    private InputStream createInputStream(final String resourceName, final ClassLoader loader, final boolean reload) throws IOException {
        InputStream stream = null;
        try {
            stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    InputStream is = null;
                    if (reload) {
                        URLConnection connection;
                        URL url = loader.getResource(resourceName);
                        if (url != null && (connection = url.openConnection()) != null) {
                            connection.setUseCaches(false);
                            is = connection.getInputStream();
                        }
                    } else {
                        is = loader.getResourceAsStream(resourceName);
                    }
                    return is;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return stream;
    }
}

