/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.AppConfigurationException;
import java.util.Properties;
import java.util.Set;

public class AppSettings {
    public static final String APP_DB_SUBNET = "app.db.subnet";
    public static final String APP_DB_SUBNET_INCLUDE_INACTIVE = "app.db.subnet.include_inactive";
    public static final String APP_DB_PATH = "app.db.path";
    public static final String APP_UI_PLUGIN = "app.ui.plugin";
    public static final String APP_LOG_FOLDER = "app.log.folder";
    public static final String DB_ENGINE = "db.engine";
    public static final String DB_NAME = "db.name";
    public static final String DB_PERSISTENCE_PROVIDER = "db.persistence.provider";
    public static final String DB_PERSISTENCE_PROVIDER_NAME = "db.persistence.provider.name";
    public static final String DB_CONNECTION_DRIVER = "db.connection.driver";
    public static final String DB_CONNECTION_URL = "db.connection.url";
    public static final String DB_CONNECTION_USER = "db.connection.user";
    public static final String DB_CONNECTION_PASSWORD = "db.connection.password";
    public static final String DB_HIBERNATE_DIALECT = "db.hibernate.dialect";
    public static final String DB_DATABASE_PROVIDER_NAME = "db.database.provider.name";
    public static final String APP_NAME = "app.name";
    public static final String APP_VERSION = "app.version";
    public static final String APP_RELEASE = "app.release";
    public static final String APP_MODLEVEL = "app.modlevel";
    public static final String APP_OPA_FM = "app.opa.fm";
    public static final String APP_BUILD_ID = "app.build.id";
    public static final String APP_BUILD_DATE = "app.build.date";
    public static final String APP_SCHEMA_LEVEL = "app.schema.level";
    public static final String APP_INTEL_PATH = "app.intel.path";
    public static final String APP_DATA_PATH = "app.data.path";
    public static final String APP_NET_DEBUG = "app.net.debug";
    public static final String APP_FAILOVER_TIMEOUT = "app.failover.timeout";
    public static final String APP_ADAPTER_USENEW = "app.adapter.usenew";
    public static final String PERF_IMAGEINFO_CACHESIZE = "perf.imageinfo.cachesize";
    public static final String PERF_IMAGEINFO_SAVEBATCH = "perf.imageinfo.savebatch";
    public static final String PERF_GROUPINFO_SAVEBATCH = "perf.groupinfo.savebatch";
    public static final String PERF_GROUPINFO_PURGEFREQ = "perf.groupinfo.purgefreq";
    public static final String PERF_GROUPINFO_RETENTION = "perf.groupinfo.retention";
    private final Properties properties;

    public AppSettings(Properties properties) {
        this.properties = properties;
    }

    public String getConfigOption(String option) throws AppConfigurationException {
        this.checkSettingExists(option);
        return this.properties.getProperty(option);
    }

    public String getConfigOption(String option, String defaultValue) {
        if (!this.properties.containsKey(option)) {
            return defaultValue;
        }
        return this.properties.getProperty(option);
    }

    public void setConfigOption(String option, String value) {
        this.properties.put(option, value);
    }

    public void setConfigOption(String option, Object value) {
        this.properties.put(option, value);
    }

    public void removeConfigOption(String option) {
        this.properties.remove(option);
    }

    public Set<Object> keySet() {
        return this.properties.keySet();
    }

    public String getAppName() throws AppConfigurationException {
        this.checkSettingExists(APP_NAME);
        return (String)this.properties.get(APP_NAME);
    }

    public Integer getAppVersion() throws AppConfigurationException {
        this.checkSettingExists(APP_VERSION);
        return (Integer)this.properties.get(APP_VERSION);
    }

    public Integer getAppRelease() throws AppConfigurationException {
        this.checkSettingExists(APP_RELEASE);
        return (Integer)this.properties.get(APP_RELEASE);
    }

    public Integer getAppModLevel() throws AppConfigurationException {
        this.checkSettingExists(APP_MODLEVEL);
        return (Integer)this.properties.get(APP_MODLEVEL);
    }

    public String getOpaFmVersion() throws AppConfigurationException {
        this.checkSettingExists(APP_OPA_FM);
        return (String)this.properties.get(APP_OPA_FM);
    }

    public String getAppBuildId() throws AppConfigurationException {
        this.checkSettingExists(APP_BUILD_ID);
        return (String)this.properties.get(APP_BUILD_ID);
    }

    public String getAppBuildDate() throws AppConfigurationException {
        this.checkSettingExists(APP_BUILD_DATE);
        return (String)this.properties.get(APP_BUILD_DATE);
    }

    public Integer getAppSchemaLevel() throws AppConfigurationException {
        this.checkSettingExists(APP_SCHEMA_LEVEL);
        return (Integer)this.properties.get(APP_SCHEMA_LEVEL);
    }

    private void checkSettingExists(String setting) throws AppConfigurationException {
        if (!this.properties.containsKey(setting)) {
            AppConfigurationException ace = new AppConfigurationException(STLMessages.STL10007_CONFIGURATION_OPTION_NOT_SET.getDescription(setting));
            throw ace;
        }
    }
}

