/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.configuration;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.impl.SubnetContextImpl;
import com.intel.stl.api.notice.impl.NoticeProcess;
import com.intel.stl.api.performance.impl.GroupCache;
import com.intel.stl.api.performance.impl.GroupConfCache;
import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.api.performance.impl.PMConfigCache;
import com.intel.stl.api.subnet.impl.CableCache;
import com.intel.stl.api.subnet.impl.LFTCache;
import com.intel.stl.api.subnet.impl.LinkCache;
import com.intel.stl.api.subnet.impl.MFTCache;
import com.intel.stl.api.subnet.impl.NodeCache;
import com.intel.stl.api.subnet.impl.PKeyTableCache;
import com.intel.stl.api.subnet.impl.PortCache;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.api.subnet.impl.SC2SLMTCache;
import com.intel.stl.api.subnet.impl.SC2VLNTMTCache;
import com.intel.stl.api.subnet.impl.SC2VLTMTCache;
import com.intel.stl.api.subnet.impl.SMCache;
import com.intel.stl.api.subnet.impl.SwitchCache;
import com.intel.stl.api.subnet.impl.TopologyUpdateTask;
import com.intel.stl.api.subnet.impl.VLArbTableCache;
import com.intel.stl.common.STLMessages;
import com.intel.stl.configuration.CacheManager;
import com.intel.stl.configuration.DBCacheType;
import com.intel.stl.configuration.ManagedCache;
import com.intel.stl.configuration.MemCacheType;
import com.intel.stl.configuration.ResultHandler;
import com.intel.stl.configuration.SerialProcessingService;
import com.intel.stl.datamanager.DatabaseManager;
import com.intel.stl.fecdriver.session.ISession;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManagerImpl
implements CacheManager {
    private static final long THROTTLE_TIMEOUT = 300000L;
    private static Logger log = LoggerFactory.getLogger(CacheManagerImpl.class);
    private final SubnetContextImpl subnetContext;
    private final Map<String, ManagedCache> allCaches = new ConcurrentHashMap<String, ManagedCache>(10, 0.9f, 1);
    private final Map<MemCacheType, ManagedCache> caches = new ConcurrentHashMap<MemCacheType, ManagedCache>(8, 0.9f, 1);
    private final boolean useDB;
    private final AtomicReference<TopologyUpdateTask> topologyUpdateRef;
    private boolean throttleTask = false;
    private long lastErrorTimestamp = 0L;

    public CacheManagerImpl(SubnetContextImpl subnetContext) {
        this.subnetContext = subnetContext;
        this.topologyUpdateRef = new AtomicReference<Object>(null);
        this.useDB = Boolean.parseBoolean(subnetContext.getAppSetting("app.db.subnet", "true"));
    }

    @Override
    public SerialProcessingService getProcessingService() {
        return this.subnetContext.getProcessingService();
    }

    @Override
    public DatabaseManager getDatabaseManager() {
        return this.subnetContext.getDatabaseManager();
    }

    @Override
    public SAHelper getSAHelper() {
        ISession session = this.subnetContext.getSession();
        return session.getSAHelper();
    }

    @Override
    public PAHelper getPAHelper() {
        ISession session = this.subnetContext.getSession();
        return session.getPAHelper();
    }

    @Override
    public NodeCache acquireNodeCache() {
        return (NodeCache)((Object)this.getManagedCache(MemCacheType.NODE));
    }

    @Override
    public LinkCache acquireLinkCache() {
        return (LinkCache)((Object)this.getManagedCache(MemCacheType.LINK));
    }

    @Override
    public PortCache acquirePortCache() {
        return (PortCache)((Object)this.getManagedCache(MemCacheType.PORT));
    }

    @Override
    public SwitchCache acquireSwitchCache() {
        return (SwitchCache)((Object)this.getManagedCache(MemCacheType.SWITCH));
    }

    @Override
    public LFTCache acquireLFTCache() {
        return (LFTCache)((Object)this.getManagedCache(MemCacheType.LFT));
    }

    @Override
    public MFTCache acquireMFTCache() {
        return (MFTCache)((Object)this.getManagedCache(MemCacheType.MFT));
    }

    @Override
    public CableCache acquireCableCache() {
        return (CableCache)((Object)this.getManagedCache(MemCacheType.CABLE));
    }

    @Override
    public PKeyTableCache acquirePKeyTableCache() {
        return (PKeyTableCache)((Object)this.getManagedCache(MemCacheType.PKEYTABLE));
    }

    @Override
    public VLArbTableCache acquireVLArbTableCache() {
        return (VLArbTableCache)((Object)this.getManagedCache(MemCacheType.VLARBTABLE));
    }

    @Override
    public SMCache acquireSMCache() {
        return (SMCache)((Object)this.getManagedCache(MemCacheType.SM));
    }

    @Override
    public GroupCache acquireGroupCache() {
        return (GroupCache)((Object)this.getManagedCache(MemCacheType.GROUP));
    }

    @Override
    public GroupConfCache acquireGroupConfCache() {
        return (GroupConfCache)((Object)this.getManagedCache(MemCacheType.GROUP_CONF));
    }

    @Override
    public PMConfigCache acquirePMConfigCache() {
        return (PMConfigCache)((Object)this.getManagedCache(MemCacheType.PM_CONF));
    }

    @Override
    public SC2SLMTCache acquireSC2SLMTCache() {
        return (SC2SLMTCache)((Object)this.getManagedCache(MemCacheType.SC2SL));
    }

    @Override
    public SC2VLTMTCache acquireSC2VLTMTCache() {
        return (SC2VLTMTCache)((Object)this.getManagedCache(MemCacheType.SC2VLT));
    }

    @Override
    public SC2VLNTMTCache acquireSC2VLNTMTCache() {
        return (SC2VLNTMTCache)((Object)this.getManagedCache(MemCacheType.SC2VLNT));
    }

    @Override
    public void startTopologyUpdateTask() {
        log.info("Starting topology update task");
        this.startTopologyUpdate();
    }

    private ManagedCache getManagedCache(MemCacheType cacheType) {
        ManagedCache cache = this.caches.get((Object)cacheType);
        if (cache == null) {
            throw new RuntimeException(STLMessages.STL30073_NO_CACHE_FOUND.getDescription(new Object[]{cacheType}));
        }
        boolean cacheReady = cache.isCacheReady();
        if (!cacheReady) {
            cache.updateCache();
        }
        return cache;
    }

    @Override
    public void updateCaches(NoticeProcess notice) throws Exception {
        for (ManagedCache cache : this.allCaches.values()) {
            cache.processNotice(notice);
        }
    }

    public synchronized void initialize() {
        this.createCaches();
    }

    private void createCaches() {
        MemCacheType[] memCaches = MemCacheType.values();
        for (int i = 0; i < memCaches.length; ++i) {
            MemCacheType cacheType = memCaches[i];
            String cacheName = cacheType.getImplementingClassName();
            if (this.allCaches.get(cacheName) != null) continue;
            try {
                ManagedCache cache = cacheType.getInstance(this);
                this.allCaches.put(cacheName, cache);
                this.caches.put(cacheType, cache);
                continue;
            }
            catch (Exception e) {
                String emsg = "Error instantiating cache '" + cacheName + "': " + StringUtils.getErrorMessage(e);
                log.error(emsg, (Throwable)e);
                RuntimeException rte = new RuntimeException(emsg, e);
                throw rte;
            }
        }
        DBCacheType[] dbCaches = DBCacheType.values();
        for (int i = 0; i < dbCaches.length; ++i) {
            DBCacheType dbCacheType = dbCaches[i];
            String cacheName = dbCacheType.getImplementingClassName();
            if (this.allCaches.get(cacheName) != null) continue;
            try {
                ManagedCache cache = dbCacheType.getInstance(this);
                this.allCaches.put(cacheName, cache);
                continue;
            }
            catch (Exception e) {
                String emsg = "Error instantiating cache '" + cacheName + "': " + StringUtils.getErrorMessage(e);
                log.error(emsg, (Throwable)e);
                RuntimeException rte = new RuntimeException(emsg, e);
                throw rte;
            }
        }
    }

    private void startTopologyUpdate() {
        long now;
        SAHelper helper;
        boolean updated;
        if (!this.useDB) {
            log.info("Topology update task not started because of user setting");
            return;
        }
        TopologyUpdateTask topologyUpdate = this.topologyUpdateRef.get();
        if (topologyUpdate == null && !(updated = this.topologyUpdateRef.compareAndSet(null, topologyUpdate = new TopologyUpdateTask(helper = this.subnetContext.getSession().getSAHelper(), this.getDatabaseManager())))) {
            return;
        }
        if (topologyUpdate.getFuture() != null && !topologyUpdate.getFuture().isDone()) {
            log.warn("Attempting to start a topology update task but the previous has not finished yet");
            return;
        }
        if (this.throttleTask && (now = System.currentTimeMillis()) - this.lastErrorTimestamp < 300000L) {
            log.warn("Topology update task was not started due to throttle");
            return;
        }
        this.getProcessingService().submitSerial(topologyUpdate, new ResultHandler<Void>(){

            @Override
            public void onTaskCompleted(Future<Void> result) {
                try {
                    result.get();
                    DBCacheType[] dbCaches = DBCacheType.values();
                    for (int i = 0; i < dbCaches.length; ++i) {
                        DBCacheType dbCacheType = dbCaches[i];
                        MemCacheType cacheType = dbCacheType.getMemCacheType();
                        ManagedCache cache = (ManagedCache)CacheManagerImpl.this.caches.get((Object)cacheType);
                        if (cache == null || cache.getClass().getCanonicalName().equals(dbCacheType.getImplementingClassName())) continue;
                        ManagedCache dbCache = (ManagedCache)CacheManagerImpl.this.allCaches.get(dbCacheType.getImplementingClassName());
                        CacheManagerImpl.this.caches.put(cacheType, dbCache);
                    }
                    CacheManagerImpl.this.topologyUpdateRef.set(null);
                    CacheManagerImpl.this.throttleTask = false;
                }
                catch (InterruptedException e) {
                    log.error("Topology update task was interrupted", (Throwable)e);
                    CacheManagerImpl.this.topologyUpdateRef.set(null);
                    CacheManagerImpl.this.lastErrorTimestamp = System.currentTimeMillis();
                    CacheManagerImpl.this.throttleTask = true;
                }
                catch (ExecutionException e) {
                    log.error("Exception caught during topology update task", e.getCause());
                    CacheManagerImpl.this.topologyUpdateRef.set(null);
                    CacheManagerImpl.this.lastErrorTimestamp = System.currentTimeMillis();
                    CacheManagerImpl.this.throttleTask = true;
                }
            }
        });
    }

    @Override
    public void reset() {
        for (ManagedCache cache : this.caches.values()) {
            cache.reset();
        }
        for (DBCacheType dbct : DBCacheType.values()) {
            MemCacheType mct = dbct.getMemCacheType();
            String cacheName = mct.getImplementingClassName();
            ManagedCache cache = this.allCaches.get(cacheName);
            if (cache != null) {
                cache.reset();
                this.caches.put(mct, cache);
                continue;
            }
            log.warn("Cannot find cache '" + cacheName + "'");
        }
    }

    @Override
    public void cleanup() {
    }

    protected Map<MemCacheType, ManagedCache> getCaches() {
        return this.caches;
    }

    protected TopologyUpdateTask getTopologyUpdateTask() {
        return this.topologyUpdateRef.get();
    }
}

