/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.api.configuration.EventRule;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.datamanager.DatabaseRecord;
import com.intel.stl.datamanager.EventActionRecord;
import com.intel.stl.datamanager.SubnetRecord;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity
@Table(name="EVENT_RULES")
public class EventRuleRecord
extends DatabaseRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(length=32)
    private String eventName;
    private EventRule eventRule;
    @ManyToMany
    @JoinTable(name="EVENT_RULES_SUBNETS", joinColumns={@JoinColumn(name="eventName", referencedColumnName="eventName")}, inverseJoinColumns={@JoinColumn(name="subnetId", referencedColumnName="subnetId")})
    private Set<SubnetRecord> eventSubnets;
    @ManyToMany
    @JoinTable(name="EVENT_RULES_ACTIONS", joinColumns={@JoinColumn(name="eventName", referencedColumnName="eventName")}, inverseJoinColumns={@JoinColumn(name="eventAction", referencedColumnName="id")})
    private Set<EventActionRecord> eventActions;

    public EventRuleRecord() {
    }

    public EventRuleRecord(EventRule eventRule) {
        this.eventRule = eventRule;
        this.eventName = eventRule.getEventName();
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public EventRule getEventRule() {
        this.eventRule.setEventName(this.eventName);
        Set<SubnetRecord> subnets = this.getEventSubnets();
        HashSet<SubnetDescription> eventSubnets = new HashSet<SubnetDescription>();
        if (subnets != null) {
            for (SubnetRecord subnet : subnets) {
                eventSubnets.add(subnet.getSubnetDescription());
            }
        }
        this.eventRule.setEventSubnets(eventSubnets);
        Set<EventActionRecord> actions = this.getEventActions();
        ArrayList<EventRuleAction> eventActions = new ArrayList<EventRuleAction>();
        if (actions != null) {
            for (EventActionRecord action : actions) {
                eventActions.add(action.getAction());
            }
        }
        this.eventRule.setEventActions(eventActions);
        return this.eventRule;
    }

    public void setEventRule(EventRule eventRule) {
        this.eventRule = eventRule;
    }

    public Set<SubnetRecord> getEventSubnets() {
        return this.eventSubnets;
    }

    public void setEventSubnets(Set<SubnetRecord> eventSubnets) {
        this.eventSubnets = eventSubnets;
    }

    public Set<EventActionRecord> getEventActions() {
        return this.eventActions;
    }

    public void setEventActions(Set<EventActionRecord> eventActions) {
        this.eventActions = eventActions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.eventName == null ? 0 : this.eventName.toLowerCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventRuleRecord other = (EventRuleRecord)obj;
        return !(this.eventName == null ? other.eventName != null : !this.eventName.equalsIgnoreCase(other.eventName));
    }
}

