/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.api.performance.ImageInfoBean;
import com.intel.stl.datamanager.ImageInfoId;
import com.intel.stl.datamanager.SubnetRecord;
import java.io.Serializable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="IMAGE_INFOS", indexes={@Index(name="IDX_IMAGE_NUM", columnList="imageNumber", unique=false)})
public class ImageInfoRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ImageInfoId id = new ImageInfoId();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subnetId", insertable=false, updatable=false)
    private SubnetRecord subnet;
    @Embedded
    private ImageInfoBean imageInfo;

    public ImageInfoRecord() {
    }

    public ImageInfoRecord(long subnetId, ImageInfoBean imageInfo) {
        this.id.setFabricId(subnetId);
        this.setImageInfoFields(imageInfo);
        this.imageInfo = imageInfo;
    }

    public ImageInfoId getId() {
        return this.id;
    }

    public void setId(ImageInfoId id) {
        this.id = id;
    }

    public SubnetRecord getSubnet() {
        return this.subnet;
    }

    public void setSubnet(SubnetRecord subnet) {
        this.subnet = subnet;
    }

    public ImageInfoBean getImageInfo() {
        return this.imageInfo;
    }

    public void setImageInfo(ImageInfoBean imageInfo) {
        this.setImageInfoFields(imageInfo);
        this.imageInfo = imageInfo;
    }

    private void setImageInfoFields(ImageInfoBean imageInfo) {
        this.id.setSweepTimestamp(imageInfo.getSweepStart());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageInfoRecord other = (ImageInfoRecord)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

