/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.datamanager;

import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.datamanager.DatabaseRecord;
import com.intel.stl.datamanager.EventRuleRecord;
import com.intel.stl.datamanager.GroupConfigRecord;
import com.intel.stl.datamanager.ImageInfoRecord;
import com.intel.stl.datamanager.TopologyRecord;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;

@Entity
@Table(name="SUBNETS", indexes={@Index(name="IDX_SUBNET_NAME", columnList="uniqueName", unique=true)})
@Cacheable(value=true)
public class SubnetRecord
extends DatabaseRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @TableGenerator(name="TABLE_GEN", pkColumnValue="SUBNET_SEQ", allocationSize=1, initialValue=1)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="TABLE_GEN")
    @Column(name="subnetId")
    private long id;
    @Column(name="uniqueName", length=80)
    private String uniqueName;
    private SubnetDescription subnetDescription;
    @ManyToMany(mappedBy="eventSubnets")
    private Set<EventRuleRecord> eventRules;
    @OneToOne(fetch=FetchType.LAZY)
    private TopologyRecord topology;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="subnet")
    private Set<GroupConfigRecord> groups;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="subnet")
    private Set<ImageInfoRecord> images;

    public SubnetRecord() {
    }

    public SubnetRecord(SubnetDescription subnetDescription) {
        this.id = subnetDescription.getSubnetId();
        this.subnetDescription = subnetDescription;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public SubnetDescription getSubnetDescription() {
        this.subnetDescription.setSubnetId(this.id);
        return this.subnetDescription;
    }

    public void setSubnetDescription(SubnetDescription subnetDescription) {
        this.subnetDescription = subnetDescription;
    }

    public Set<EventRuleRecord> getEventRules() {
        return this.eventRules;
    }

    public void setEventRules(Set<EventRuleRecord> eventRules) {
        this.eventRules = eventRules;
    }

    public TopologyRecord getTopology() {
        return this.topology;
    }

    public void setTopology(TopologyRecord topology) {
        this.topology = topology;
    }

    public Set<GroupConfigRecord> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<GroupConfigRecord> groups) {
        this.groups = groups;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubnetRecord other = (SubnetRecord)obj;
        return this.id == other.id;
    }
}

