/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.StringUtils;
import com.intel.stl.api.configuration.EventRuleAction;
import com.intel.stl.api.subnet.NodeType;
import com.intel.stl.common.STLMessages;
import com.intel.stl.datamanager.EventActionRecord;
import com.intel.stl.datamanager.NodeTypeRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseUtils {
    private static final String SQL_CMD_SEPARATOR = "GO";
    private static final String SQL_SELECT_COUNT = "SELECT COUNT(*) FROM ";
    protected static String[] SQL_CHECK_TABLES = new String[]{"Subnet", "Node", "Port", "Topology"};
    private static Logger log = LoggerFactory.getLogger(DatabaseUtils.class);

    public static DatabaseException createPersistDatabaseException(Throwable cause, Class<?> entityClass, Object entityId) {
        Throwable last = cause;
        while (last.getCause() != null) {
            last = last.getCause();
        }
        String entity = entityClass.getSimpleName();
        DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30013_ERROR_SAVING_ENTITY, cause, entity, entityId, StringUtils.getErrorMessage(last));
        return dbe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkDatabase(Connection conn) {
        boolean databaseCreated = true;
        try {
            try (Statement stmt = conn.createStatement();){
                for (int i = 0; i < SQL_CHECK_TABLES.length; ++i) {
                    try {
                        ResultSet rs = stmt.executeQuery(SQL_SELECT_COUNT + SQL_CHECK_TABLES[i] + ";");
                        if (rs == null) continue;
                        rs.close();
                        continue;
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() != -5501) {
                            log.error(STLMessages.STL30006_SQLEXCEPTION.getDescription(e.getErrorCode(), e.getMessage()));
                        }
                        databaseCreated = false;
                    }
                }
            }
            return databaseCreated;
        }
        catch (SQLException e) {
            log.error(STLMessages.STL30006_SQLEXCEPTION.getDescription(e.getErrorCode(), e.getMessage()));
            databaseCreated = false;
            return databaseCreated;
        }
    }

    public static void defineDatabase(Connection conn, String definitionFile) throws DatabaseException {
        block17: {
            URL dbDefUrl = DatabaseUtils.class.getResource(definitionFile);
            if (dbDefUrl != null) {
                InputStream istream = null;
                BufferedReader in = null;
                try {
                    istream = dbDefUrl.openStream();
                }
                catch (IOException e) {
                    DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30004_ERROR_READING_DATABASE_DEFINITION, (Throwable)e);
                    log.error(dbe.getMessage(), (Throwable)e);
                    throw dbe;
                }
                in = new BufferedReader(new InputStreamReader(istream));
                try {
                    String line = in.readLine();
                    StringBuffer sqlCmd = new StringBuffer();
                    boolean definitionError = false;
                    while (line != null) {
                        String trimmedLine = line.trim();
                        if (SQL_CMD_SEPARATOR.equalsIgnoreCase(trimmedLine)) {
                            String sqlStr = sqlCmd.toString();
                            if (!DatabaseUtils.executeSQLCmd(conn, sqlStr)) {
                                definitionError = true;
                            }
                            sqlCmd = new StringBuffer();
                        } else {
                            sqlCmd.append(trimmedLine);
                            sqlCmd.append(" ");
                        }
                        line = in.readLine();
                    }
                    if (definitionError) {
                        DatabaseException dbe = new DatabaseException(STLMessages.STL30005_ERRORS_DURING_DATABASE_DEFINITION);
                        throw dbe;
                    }
                    break block17;
                }
                catch (IOException e) {
                    DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL30004_ERROR_READING_DATABASE_DEFINITION, (Throwable)e);
                    log.error(dbe.getMessage(), (Throwable)e);
                    throw dbe;
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            DatabaseException dbe = new DatabaseException(STLMessages.STL30003_DATABASE_DEFINITION_FILE_NOT_FOUND);
            throw dbe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeSQLCmd(Connection conn, String sqlCmd) {
        log.debug("Executing SQL command: " + sqlCmd);
        boolean result = true;
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sqlCmd);
        }
        catch (SQLException se) {
            log.error(STLMessages.STL30002_DATABASE_ENGINE_ERROR.getDescription(se.getErrorCode(), sqlCmd), (Throwable)se);
            result = false;
        }
        return result;
    }

    public static void populateRequiredTables(EntityManager em) {
        int i;
        NodeType[] types = (NodeType[])NodeType.class.getEnumConstants();
        EventRuleAction[] actions = (EventRuleAction[])EventRuleAction.class.getEnumConstants();
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        for (i = 0; i < types.length; ++i) {
            NodeTypeRecord type = new NodeTypeRecord();
            type.setId(types[i].getId());
            type.setNodeType(types[i]);
            em.persist((Object)type);
        }
        for (i = 0; i < actions.length; ++i) {
            EventActionRecord action = new EventActionRecord();
            action.setId(actions[i].name());
            action.setAction(actions[i]);
            em.persist((Object)action);
        }
        tx.commit();
    }

    public static long getDatabaseDefinitionTimestamp(String definitionFile) throws DatabaseException {
        URL dbDefUrl = DatabaseUtils.class.getResource(definitionFile);
        long timestamp = 0L;
        if (dbDefUrl != null) {
            try {
                URLConnection urlConn = dbDefUrl.openConnection();
                timestamp = urlConn.getLastModified();
            }
            catch (IOException e) {
                DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL10009_ERROR_READING_FILE, (Throwable)e, StringUtils.getErrorMessage(e));
                log.error(dbe.getMessage(), (Throwable)e);
                throw dbe;
            }
        } else {
            DatabaseException dbe = new DatabaseException(STLMessages.STL30003_DATABASE_DEFINITION_FILE_NOT_FOUND);
            throw dbe;
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDatabaseTimestamp(File timestampFile) throws DatabaseException {
        long timestamp = 0L;
        try (BufferedReader in = new BufferedReader(new FileReader(timestampFile));){
            String line = in.readLine();
            if (line != null) {
                timestamp = Long.parseLong(line);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            DatabaseException dbe = new DatabaseException((IMessage)STLMessages.STL10009_ERROR_READING_FILE, (Throwable)e, timestampFile.getAbsolutePath(), StringUtils.getErrorMessage(e));
            log.error(dbe.getMessage(), (Throwable)e);
            throw dbe;
        }
        return timestamp;
    }

    public static void setSqlCheckTables(String[] tables) {
        SQL_CHECK_TABLES = tables;
    }
}

