/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.dbengine.impl;

import com.intel.stl.api.DatabaseException;
import com.intel.stl.api.IMessage;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.GroupListBean;
import com.intel.stl.api.performance.PerformanceDataNotFoundException;
import com.intel.stl.api.performance.PortConfigBean;
import com.intel.stl.common.STLMessages;
import com.intel.stl.datamanager.GroupConfigId;
import com.intel.stl.datamanager.GroupConfigRecord;
import com.intel.stl.datamanager.GroupInfoId;
import com.intel.stl.datamanager.GroupInfoRecord;
import com.intel.stl.datamanager.PortConfigId;
import com.intel.stl.datamanager.PortConfigRecord;
import com.intel.stl.datamanager.SubnetRecord;
import com.intel.stl.datamanager.TopologyRecord;
import com.intel.stl.dbengine.DatabaseContext;
import com.intel.stl.dbengine.GroupDAO;
import com.intel.stl.dbengine.impl.BaseDAO;
import com.intel.stl.dbengine.impl.DatabaseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupDAOImpl
extends BaseDAO
implements GroupDAO {
    private static Logger log = LoggerFactory.getLogger((String)"org.hibernate.SQL");
    protected static int BATCH_SIZE = 1000;
    protected static int BATCH_DELETE = 100;

    public GroupDAOImpl(EntityManager entityManager) {
        super(entityManager);
    }

    public GroupDAOImpl(EntityManager entityManager, DatabaseContext databaseCtx) {
        super(entityManager, databaseCtx);
    }

    @Override
    public GroupConfigRecord saveGroupConfig(SubnetRecord subnet, String groupName, List<PortConfigBean> ports) {
        GroupConfigRecord newGroupConfig = null;
        newGroupConfig = this.createGroupConfig(subnet, groupName, ports);
        return newGroupConfig;
    }

    @Override
    public void saveGroupList(SubnetRecord subnet, List<GroupListBean> groupList) {
        int numGroups = groupList.size();
        ArrayList<GroupConfigId> saveList = new ArrayList<GroupConfigId>();
        for (int i = 0; i < numGroups; ++i) {
            GroupConfigId groupConfigId = new GroupConfigId();
            groupConfigId.setFabricId(subnet.getId());
            groupConfigId.setSubnetGroup(groupList.get(i).getGroupName());
            GroupConfigRecord groupConfig = (GroupConfigRecord)this.em.find(GroupConfigRecord.class, (Object)groupConfigId);
            if (groupConfig != null) continue;
            saveList.add(groupConfigId);
        }
        if (saveList.size() > 0) {
            StringBuffer keys = new StringBuffer();
            keys.append(subnet.getSubnetDescription().getName());
            int separator = 124;
            this.startTransaction();
            for (GroupConfigId id : saveList) {
                GroupConfigRecord groupConfigRec = new GroupConfigRecord();
                groupConfigRec.setId(id);
                keys.append((char)separator);
                keys.append(id.getSubnetGroup());
                separator = 44;
                this.em.persist((Object)groupConfigRec);
            }
            try {
                this.commitTransaction();
            }
            catch (Exception e) {
                throw this.createPersistDatabaseException(e, GroupConfigRecord.class, keys);
            }
        }
    }

    private GroupConfigRecord createGroupConfig(SubnetRecord subnet, String groupName, List<PortConfigBean> ports) {
        GroupConfigRecord groupConfigRec = new GroupConfigRecord();
        GroupConfigId groupConfigId = new GroupConfigId();
        groupConfigId.setFabricId(subnet.getId());
        groupConfigId.setSubnetGroup(groupName);
        groupConfigRec.setId(groupConfigId);
        this.startTransaction();
        this.em.persist((Object)groupConfigRec);
        this.persistGroupPorts(groupConfigRec, ports);
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            throw this.createPersistDatabaseException(e, GroupConfigRecord.class, groupName);
        }
        return groupConfigRec;
    }

    private void persistGroupPorts(GroupConfigRecord groupConfig, List<PortConfigBean> ports) {
        long updates = 0L;
        if (ports != null) {
            for (int i = 0; i < ports.size(); ++i) {
                PortConfigBean portConfigBean = ports.get(i);
                PortConfigRecord portConfigRec = new PortConfigRecord();
                PortConfigId portConfigId = new PortConfigId();
                portConfigId.setGroupId(groupConfig.getId());
                portConfigId.setNodeGUID(portConfigBean.getNodeGUID());
                portConfigId.setPortNumber(portConfigBean.getPortNumber());
                portConfigRec.setId(portConfigId);
                portConfigRec.setGroupConfig(groupConfig);
                this.em.persist((Object)portConfigRec);
                if (++updates < (long)BATCH_SIZE) continue;
                this.flush();
                this.clear();
                updates = 0L;
            }
            if (updates > 0L) {
                this.flush();
                this.clear();
            }
        }
    }

    @Override
    public List<PortConfigBean> getPortConfig(SubnetRecord subnetRec) throws PerformanceDataNotFoundException {
        TopologyRecord topology = subnetRec.getTopology();
        long topologyId = topology.getId();
        TypedQuery query = this.em.createNamedQuery("PortConfigBean.findByTopId", PortConfigBean.class);
        query.setParameter("topologyId", (Object)topologyId);
        List portConfigBean = query.getResultList();
        if (portConfigBean == null || portConfigBean.size() == 0) {
            throw this.createPortConfigNotFoundException(topologyId);
        }
        return portConfigBean;
    }

    @Override
    public List<PortConfigBean> getGroupConfig(GroupConfigId groupConfigId) throws PerformanceDataNotFoundException {
        long subnetId = groupConfigId.getFabricId();
        String groupName = groupConfigId.getSubnetGroup();
        TypedQuery query = this.em.createNamedQuery("PortConfigBean.findByGroupName", PortConfigBean.class);
        query.setParameter("subnetId", (Object)subnetId);
        query.setParameter("groupName", (Object)groupName);
        List portConfigBean = query.getResultList();
        if (portConfigBean == null || portConfigBean.size() == 0) {
            GroupConfigRecord rec = (GroupConfigRecord)this.em.find(GroupConfigRecord.class, (Object)groupConfigId);
            if (rec == null) {
                throw this.createGroupConfigNotFoundException(groupConfigId.getFabricId(), groupConfigId.getSubnetGroup());
            }
            portConfigBean = Collections.emptyList();
        }
        return portConfigBean;
    }

    @Override
    public void saveGroupInfos(SubnetRecord subnet, List<GroupInfoBean> groupInfoBeans) {
        StringBuffer keys = new StringBuffer();
        keys.append(subnet.getSubnetDescription().getName());
        int separator = 124;
        this.startTransaction();
        long now = System.currentTimeMillis();
        for (GroupInfoBean groupInfo : groupInfoBeans) {
            GroupInfoRecord groupInfoRec = this.createGroupInfo(subnet, groupInfo);
            GroupInfoRecord dbGroupInfo = (GroupInfoRecord)this.em.find(GroupInfoRecord.class, (Object)groupInfoRec.getId());
            if (dbGroupInfo != null) continue;
            this.em.persist((Object)groupInfoRec);
            keys.append((char)separator);
            GroupInfoId groupInfoId = groupInfoRec.getId();
            if (groupInfoId != null) {
                GroupConfigId groupConfigId = groupInfoId.getGroupID();
                if (groupConfigId != null) {
                    String subnetGroup = groupConfigId.getSubnetGroup();
                    keys.append(subnetGroup);
                    keys.append('-');
                    keys.append(groupInfoRec.getGroupInfo().getTimestamp());
                    separator = 44;
                    continue;
                }
                throw new RuntimeException("groupConfigId is null in saveGroupInfos.");
            }
            throw new RuntimeException("groupInfoId is null in saveGroupInfos.");
        }
        try {
            this.commitTransaction();
        }
        catch (Exception e) {
            throw this.createPersistDatabaseException(e, GroupInfoRecord.class, keys);
        }
    }

    @Override
    public int purgeGroupInfos(SubnetRecord subnet, Long ago) {
        int offset = 0;
        int deleted = 0;
        String select = "select rec from GroupInfoRecord as rec where rec.id.groupId.fabricId = :subnetId and rec.id.sweepTimestamp < :stopTime";
        TypedQuery query = this.em.createQuery(select, GroupInfoRecord.class);
        query.setParameter("subnetId", (Object)subnet.getId());
        long linuxTime = ago / 1000L;
        query.setParameter("stopTime", (Object)linuxTime);
        query.setFirstResult(offset);
        query.setMaxResults(BATCH_DELETE);
        List recs = query.getResultList();
        while (recs.size() > 0) {
            this.startTransaction();
            StringBuffer keys = new StringBuffer();
            int separator = 124;
            for (GroupInfoRecord rec : recs) {
                keys.append((char)separator);
                keys.append(rec.getId().getGroupID().getSubnetGroup());
                keys.append('-');
                keys.append(rec.getGroupInfo().getTimestamp());
                separator = 44;
                this.em.remove((Object)rec);
            }
            try {
                deleted += recs.size();
                this.flush();
                this.clear();
                this.commitTransaction();
                log.info("Deleted {} GroupInfo records before {}", (Object)recs.size(), (Object)ago);
                recs = query.getResultList();
            }
            catch (Exception e) {
                throw this.createPersistDatabaseException(e, GroupInfoRecord.class, keys);
            }
        }
        return deleted;
    }

    private GroupInfoRecord createGroupInfo(SubnetRecord subnet, GroupInfoBean groupInfo) {
        GroupInfoRecord groupInfoRec = new GroupInfoRecord();
        GroupInfoId groupInfoId = new GroupInfoId();
        groupInfoId.setSweepTimestamp(groupInfo.getTimestamp());
        GroupConfigId groupConfigId = new GroupConfigId();
        groupConfigId.setFabricId(subnet.getId());
        groupConfigId.setSubnetGroup(groupInfo.getGroupName());
        groupInfoId.setGroupID(groupConfigId);
        groupInfoRec.setId(groupInfoId);
        groupInfoRec.setGroupInfo(groupInfo);
        return groupInfoRec;
    }

    @Override
    public List<GroupInfoBean> getGroupInfoList(SubnetRecord subnet, String groupName, long startTime, long stopTime) throws PerformanceDataNotFoundException {
        TypedQuery query = this.em.createNamedQuery("GroupInfoBean.findByTime", GroupInfoRecord.class);
        query.setParameter("subnetId", (Object)subnet.getId());
        query.setParameter("groupName", (Object)groupName);
        query.setParameter("startTime", (Object)startTime);
        query.setParameter("stopTime", (Object)stopTime);
        List groupInfoRecs = query.getResultList();
        if (groupInfoRecs == null || groupInfoRecs.size() == 0) {
            throw this.createGroupInfoNotFoundException(subnet.getSubnetDescription().getName(), groupName, startTime, stopTime);
        }
        ArrayList<GroupInfoBean> groupInfoBeans = new ArrayList<GroupInfoBean>(groupInfoRecs.size());
        for (GroupInfoRecord groupInfoRec : groupInfoRecs) {
            groupInfoBeans.add(groupInfoRec.getGroupInfo());
        }
        return groupInfoBeans;
    }

    private DatabaseException createPersistDatabaseException(Throwable cause, Class<?> entityClass, Object entityId) {
        DatabaseException dbe = DatabaseUtils.createPersistDatabaseException(cause, entityClass, entityId);
        log.error(dbe.getMessage(), cause);
        return dbe;
    }

    private PerformanceDataNotFoundException createPortConfigNotFoundException(Object ... arguments) {
        PerformanceDataNotFoundException ge = new PerformanceDataNotFoundException((IMessage)STLMessages.STL30053_PORT_CONFIG_NOT_FOUND_SUBNET, arguments);
        return ge;
    }

    private PerformanceDataNotFoundException createGroupInfoNotFoundException(Object ... arguments) {
        PerformanceDataNotFoundException pe = new PerformanceDataNotFoundException((IMessage)STLMessages.STL30054_GROUP_INFO_NOT_FOUND_TIME, arguments);
        return pe;
    }

    private PerformanceDataNotFoundException createGroupConfigNotFoundException(Object ... arguments) {
        PerformanceDataNotFoundException ge = new PerformanceDataNotFoundException((IMessage)STLMessages.STL30045_GROUP_CONFIG_NOT_FOUND, arguments);
        return ge;
    }
}

