/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.dispatcher;

import com.intel.stl.fecdriver.dispatcher.Connection;
import com.intel.stl.fecdriver.dispatcher.IPoolingPolicy;
import java.util.List;

public class ConnectionPoolingPolicy
implements IPoolingPolicy<Connection> {
    public static final int MAX_CONNECTIONS_IN_POOL = 10;
    public static final int MIN_CONNECTIONS_IN_POOL = 3;
    private int nextConnection = -1;
    private final int maxPoolSize;
    private final int minPoolSize;

    public ConnectionPoolingPolicy() {
        this(10, 3);
    }

    public ConnectionPoolingPolicy(int maxPoolSize, int minPoolSize) {
        this.maxPoolSize = maxPoolSize;
        this.minPoolSize = minPoolSize;
    }

    @Override
    public int calculateNumHandlers(int currNumConns, int currNumSessions) {
        int totConn = Math.min(this.maxPoolSize, currNumSessions * 3);
        totConn = Math.max(this.minPoolSize, totConn);
        return totConn - currNumConns;
    }

    @Override
    public Connection nextHandler(List<Connection> conns) {
        ++this.nextConnection;
        if (this.nextConnection >= conns.size()) {
            this.nextConnection = 0;
        }
        return conns.get(this.nextConnection);
    }
}

