/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.dispatcher;

import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.MDC;

public abstract class Handler<R>
implements Callable<R> {
    private Map<String, String> loggingContextMap;

    public void dispatch() throws Exception {
        this.initLoggingContext();
        this.handle();
    }

    @Override
    public R call() throws Exception {
        this.initLoggingContext();
        R result = this.handle();
        return result;
    }

    protected abstract R handle() throws Exception;

    protected void setLoggingContextMap(Map<String, String> loggingContextMap) {
        this.loggingContextMap = loggingContextMap;
    }

    private void initLoggingContext() {
        if (this.loggingContextMap != null) {
            MDC.setContextMap(this.loggingContextMap);
        }
    }
}

