/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.dispatcher;

import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.fecdriver.dispatcher.Connection;
import com.intel.stl.fecdriver.dispatcher.IConnectionEventListener;
import com.intel.stl.fecdriver.dispatcher.IRequestDispatcher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureConnection
extends Connection {
    protected static Logger log = LoggerFactory.getLogger(SecureConnection.class);
    public static final String[] CIPHER_LIST = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"};
    public static final long TIME_OUT = 30000L;
    private int netBufferSize;
    private int appBufferSize;
    private ByteBuffer myNetData;
    private ByteBuffer peerNetData;
    private ByteBuffer myAppData;
    private ByteBuffer peerAppData;
    private SSLSession sslSession;
    private SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    private SSLEngine sslEngine;

    public SecureConnection(HostInfo hostInfo, SocketChannel channel, IConnectionEventListener listener) {
        super(hostInfo, channel, listener);
    }

    @Override
    protected void initialize(Selector selector, IRequestDispatcher dispatcher) throws Exception {
        this.sslEngine = dispatcher.getSSLEngine(this.hostInfo);
        super.initialize(selector, dispatcher);
        this.sslSession = this.sslEngine.getSession();
        this.netBufferSize = this.sslSession.getPacketBufferSize();
        this.appBufferSize = this.sslSession.getApplicationBufferSize();
        this.myNetData = ByteBuffer.allocate(this.netBufferSize);
        this.peerNetData = ByteBuffer.allocate(this.netBufferSize);
        this.myAppData = ByteBuffer.allocate(this.appBufferSize);
        this.peerAppData = ByteBuffer.allocate(this.appBufferSize);
    }

    @Override
    protected void onConnectionComplete() throws IOException {
        this.sslEngine.setEnabledCipherSuites(CIPHER_LIST);
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        this.peerNetData.flip();
        this.peerAppData.flip();
        this.myNetData.clear();
        this.initialHandshake = true;
        this.handshake();
    }

    @Override
    protected void handleWrite() throws IOException {
        this.turnOpsOff(4);
        if (this.flush()) {
            if (this.initialHandshake) {
                this.handshake();
            } else if (this.closing) {
                this.close();
            } else {
                super.handleWrite();
            }
        }
    }

    @Override
    protected void handleRead() throws IOException {
        if (this.initialHandshake) {
            this.handshake();
        } else if (this.closing) {
            this.close();
        } else {
            super.handleRead();
        }
    }

    @Override
    protected int readBuffer(ByteBuffer dst) throws IOException {
        this.debugBuffers("in", dst);
        int pos = dst.position();
        if (this.peerAppData.hasRemaining()) {
            this.putData(dst);
        }
        if (!dst.hasRemaining()) {
            int read = dst.position() - pos;
            log.debug("Read {} bytes from peerAppData", (Object)read);
            return read;
        }
        this.peerAppData.compact();
        int len = this.read();
        while (len > 0 && dst.hasRemaining()) {
            SSLEngineResult.Status status;
            boolean hasRemainder;
            do {
                this.peerNetData.flip();
                SSLEngineResult result = this.sslEngine.unwrap(this.peerNetData, this.peerAppData);
                this.debugHandshake("readBuffer: ", result);
                hasRemainder = this.peerNetData.hasRemaining();
                this.peerNetData.compact();
                status = result.getStatus();
                switch (status) {
                    case OK: {
                        if (dst.hasRemaining()) {
                            this.peerAppData.flip();
                            this.putData(dst);
                            this.peerAppData.compact();
                        }
                        if (!dst.hasRemaining()) break;
                        len = this.read();
                        hasRemainder = this.peerNetData.position() > 0;
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        int netBuffSize = this.sslEngine.getSession().getPacketBufferSize();
                        if (netBuffSize > this.peerNetData.capacity()) {
                            this.peerNetData = this.resizeBuffer(this.peerNetData, netBuffSize);
                            if (log.isDebugEnabled()) {
                                String peerNetDataState = this.buffer2String(this.peerNetData);
                                log.debug("peerNetData resized: {}", (Object)peerNetDataState);
                            }
                        }
                        hasRemainder = (len = this.read()) > 0;
                        status = SSLEngineResult.Status.OK;
                        break;
                    }
                    case BUFFER_OVERFLOW: {
                        this.checkNetAppBufferSize();
                        break;
                    }
                    case CLOSED: {
                        throw new ClosedChannelException();
                    }
                }
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) continue;
                this.handshake();
            } while (hasRemainder && status == SSLEngineResult.Status.OK);
        }
        if (len == -1) {
            try {
                this.sslEngine.closeInbound();
            }
            catch (SSLException se) {
                ClosedChannelException cce = new ClosedChannelException();
                cce.initCause(se);
                throw cce;
            }
        }
        if (dst.hasRemaining()) {
            this.turnOpsOn(1);
        }
        this.peerAppData.flip();
        this.debugBuffers("out", dst);
        return dst.position() - pos;
    }

    private void putData(ByteBuffer dst) {
        if (log.isDebugEnabled()) {
            String peerAppDataState = this.buffer2String(this.peerAppData);
            String dstState = this.buffer2String(dst);
            log.debug("Putting data. peerAppData: {}; dst: {}", (Object)peerAppDataState, (Object)dstState);
        }
        if (this.peerAppData.remaining() > dst.remaining()) {
            int limit = dst.remaining();
            for (int i = 0; i < limit; ++i) {
                dst.put(this.peerAppData.get());
            }
        } else {
            dst.put(this.peerAppData);
        }
    }

    @Override
    public long writeBuffers(ByteBuffer[] appBuffers) throws IOException {
        int retValue = 0;
        if (!this.flush()) {
            return retValue;
        }
        this.myNetData.clear();
        SSLEngineResult result = this.sslEngine.wrap(appBuffers, this.myNetData);
        this.debugHandshake("writeBuffers: ", result);
        retValue = result.bytesConsumed();
        switch (result.getStatus()) {
            case OK: {
                this.myNetData.flip();
                this.flush();
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) break;
                this.doTasks();
                break;
            }
            default: {
                throw new IOException("sslEngine error during data write: " + (Object)((Object)result.getStatus()));
            }
        }
        return retValue;
    }

    @Override
    public void close() throws IOException {
        this.closing = true;
        this.myAppData.clear();
        this.myAppData.flip();
        this.myNetData.compact();
        this.sslEngine.closeOutbound();
        SSLEngineResult result = null;
        while (!this.sslEngine.isOutboundDone()) {
            result = this.sslEngine.wrap(this.myAppData, this.myNetData);
            this.debugHandshake("CLOSE: ", result);
            this.myNetData.flip();
            while (this.myNetData.hasRemaining()) {
                int written = this.channel.write(this.myNetData);
                if (written != -1) continue;
                super.close();
                return;
            }
            this.myNetData.compact();
        }
        super.close();
    }

    private void handshake() throws IOException {
        while (true) {
            if (log.isDebugEnabled()) {
                String peerNetDataState = this.buffer2String(this.peerNetData);
                String peerAppDataState = this.buffer2String(this.peerAppData);
                String myNetDataState = this.buffer2String(this.myNetData);
                String myAppDataState = this.buffer2String(this.myAppData);
                log.debug("Handshake status: {}; peerNetData: {}; peerAppData: {}; myAppData: {}; myNetData: {}", new Object[]{this.handshakeStatus.toString(), peerNetDataState, peerAppDataState, myAppDataState, myNetDataState});
            }
            block0 : switch (this.handshakeStatus) {
                case NEED_UNWRAP: {
                    if (!this.peerNetData.hasRemaining()) {
                        this.peerNetData.compact();
                        int read = this.read();
                        this.peerNetData.flip();
                        if (read == 0) {
                            this.turnOpsOn(1);
                            this.turnOpsOff(4);
                            return;
                        }
                    }
                    this.peerAppData.compact();
                    SSLEngineResult result = this.sslEngine.unwrap(this.peerNetData, this.peerAppData);
                    this.peerAppData.flip();
                    this.handshakeStatus = result.getHandshakeStatus();
                    this.debugHandshake("NEED_UNWRAP: ", result);
                    switch (result.getStatus()) {
                        case OK: {
                            break block0;
                        }
                        case BUFFER_UNDERFLOW: {
                            this.peerNetData.compact();
                            int read = this.read();
                            if (read > 0) {
                                this.peerNetData.flip();
                                break block0;
                            }
                            if (read == 0) {
                                this.peerNetData.flip();
                                this.turnOpsOn(1);
                                this.turnOpsOff(4);
                                return;
                            }
                            this.sslEngine.closeInbound();
                            log.info("Not receiving any more data");
                            break block0;
                        }
                        case BUFFER_OVERFLOW: {
                            this.checkNetAppBufferSize();
                            break block0;
                        }
                        case CLOSED: {
                            throw new ClosedChannelException();
                        }
                    }
                    break;
                }
                case NEED_WRAP: {
                    if (!this.myNetData.hasRemaining()) {
                        this.myNetData.compact();
                    }
                    SSLEngineResult result = this.sslEngine.wrap(this.myAppData, this.myNetData);
                    this.handshakeStatus = result.getHandshakeStatus();
                    this.debugHandshake("NEED_WRAP: ", result);
                    switch (result.getStatus()) {
                        case OK: {
                            this.myNetData.flip();
                            if (this.flush()) break block0;
                            return;
                        }
                        case BUFFER_OVERFLOW: {
                            if (!this.flush()) {
                                return;
                            }
                            this.myNetData.clear();
                            break block0;
                        }
                    }
                    throw new IOException("Received" + (Object)((Object)result.getStatus()) + "during initial handshaking");
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.doTasks();
                    break;
                }
                case FINISHED: {
                    if (this.myNetData.hasRemaining()) {
                        this.flush();
                    }
                    boolean handshakeComplete = !this.myNetData.hasRemaining();
                    log.debug("FINISHED: " + handshakeComplete);
                    if (handshakeComplete) {
                        if (this.initialHandshake) {
                            this.completeInitialHandshake();
                        }
                    } else {
                        this.turnOpsOn(4);
                    }
                    return;
                }
                case NOT_HANDSHAKING: {
                    log.debug("Handshake is in NOT_HANDSHAKING state");
                    return;
                }
            }
        }
    }

    private int read() throws IOException {
        int read = this.channel.read(this.peerNetData);
        if (log.isDebugEnabled()) {
            String peerNetDataState = this.buffer2String(this.peerNetData);
            log.debug("Read {} bytes from socket. peerNetData: {}", (Object)read, (Object)peerNetDataState);
        }
        return read;
    }

    private void completeInitialHandshake() throws IOException {
        this.initialHandshake = false;
        this.peerNetData.compact();
        this.peerAppData.flip();
        super.onConnectionComplete();
    }

    private boolean flush() throws IOException {
        if (this.myNetData.hasRemaining()) {
            int written = this.channel.write(this.myNetData);
            if (log.isDebugEnabled()) {
                String myNetDataState = this.buffer2String(this.myNetData);
                log.debug("Written {} bytes to socket; myNetData: {}", (Object)written, (Object)myNetDataState);
            }
            if (this.myNetData.hasRemaining()) {
                this.turnOpsOn(4);
                return false;
            }
        }
        return true;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private void checkNetAppBufferSize() {
        int appBuffSize = this.sslEngine.getSession().getApplicationBufferSize();
        int newSize = (this.peerAppData.capacity() / appBuffSize + 1) * appBuffSize;
        this.peerAppData = this.resizeBuffer(this.peerAppData, newSize);
        if (log.isDebugEnabled()) {
            String peerAppDataState = this.buffer2String(this.peerAppData);
            log.debug("peerAppData resized: {}", (Object)peerAppDataState);
        }
    }

    private ByteBuffer resizeBuffer(ByteBuffer buffer, int newSize) {
        ByteBuffer bb = ByteBuffer.allocate(newSize);
        buffer.flip();
        bb.put(buffer);
        return bb;
    }

    private void debugHandshake(String label, SSLEngineResult result) {
        if (log.isDebugEnabled()) {
            log.debug(label + result.toString());
        }
    }

    private void debugBuffers(String label, ByteBuffer dst) {
        if (log.isDebugEnabled()) {
            String peerNetDataState = this.buffer2String(this.peerNetData);
            String peerAppDataState = this.buffer2String(this.peerAppData);
            String dstState = this.buffer2String(dst);
            log.debug("readBuffer {}: peerNetData: {}; peerAppData: {}; dst: {}", new Object[]{label, peerNetDataState, peerAppDataState, dstState});
        }
    }
}

