/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.pa;

import com.intel.stl.api.performance.CategoryBucketBean;
import com.intel.stl.api.performance.CategoryStatBean;
import com.intel.stl.api.performance.CategorySummaryBean;
import com.intel.stl.api.performance.GroupInfoBean;
import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.UtilStatsBean;
import com.intel.stl.common.StringUtils;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;
import java.util.ArrayList;

public class GroupInfo
extends SimpleDatagram<GroupInfoBean> {
    public GroupInfo() {
        super(684);
    }

    public void setGroupName(String name) {
        StringUtils.setString(name, this.buffer, 0, 64);
    }

    public void setImageNumber(long num) {
        this.buffer.putLong(64, num);
    }

    public void setImageOffset(int offset) {
        this.buffer.putInt(72, offset);
    }

    private UtilStatsBean getUtilStatsBean(int position) {
        this.buffer.position(position);
        UtilStatsBean bean = new UtilStatsBean();
        bean.setTotalMBps(this.buffer.getLong());
        bean.setTotalKPps(this.buffer.getLong());
        bean.setAvgMBps(this.buffer.getInt());
        bean.setMinMBps(this.buffer.getInt());
        bean.setMaxMBps(this.buffer.getInt());
        bean.setNumBWBuckets(this.buffer.getInt());
        ArrayList<Integer> buckets = new ArrayList<Integer>(10);
        for (int i = 0; i < 10; ++i) {
            buckets.add(this.buffer.getInt());
        }
        bean.setBwBuckets(buckets);
        bean.setAvgKPps(this.buffer.getInt());
        bean.setMinKPps(this.buffer.getInt());
        bean.setMaxKPps(this.buffer.getInt());
        bean.setPmaNoRespPorts(this.buffer.getShort());
        bean.setTopoIncompPorts(this.buffer.getShort());
        return bean;
    }

    private CategoryStatBean getCategoryStatBean(int position) {
        this.buffer.position(position);
        CategorySummaryBean esBean = new CategorySummaryBean();
        esBean.setIntegrityErrors(this.buffer.getInt());
        esBean.setCongestion(this.buffer.getInt());
        esBean.setSmaCongestion(this.buffer.getInt());
        esBean.setBubble(this.buffer.getInt());
        esBean.setSecurityErrors(this.buffer.getInt());
        esBean.setRoutingErrors(this.buffer.getInt());
        esBean.setUtilizationPct10(this.buffer.getShort() & 0xFFFF);
        esBean.setDiscardsPct10(this.buffer.getShort() & 0xFFFF);
        this.buffer.getInt();
        this.buffer.getInt();
        this.buffer.getInt();
        CategoryBucketBean[] ebBeans = new CategoryBucketBean[5];
        for (int i = 0; i < ebBeans.length; ++i) {
            ebBeans[i] = new CategoryBucketBean();
            ebBeans[i].setIntegrityErrors(this.buffer.getInt());
            ebBeans[i].setCongestion(this.buffer.getInt());
            ebBeans[i].setSmaCongestion(this.buffer.getInt());
            ebBeans[i].setBubble(this.buffer.getInt());
            ebBeans[i].setSecurityErrors(this.buffer.getInt());
            ebBeans[i].setRoutingErrors(this.buffer.getInt());
        }
        CategoryStatBean bean = new CategoryStatBean(esBean, ebBeans);
        return bean;
    }

    @Override
    public GroupInfoBean toObject() {
        this.buffer.clear();
        GroupInfoBean bean = new GroupInfoBean();
        byte[] byteArray = new byte[64];
        this.buffer.get(byteArray);
        bean.setGroupName(StringUtils.toString(byteArray, 0, 64));
        ImageIdBean imageId = new ImageIdBean(this.buffer.getLong(), this.buffer.getInt(), this.buffer.getInt());
        bean.setImageId(imageId);
        this.buffer.position(80);
        bean.setNumInternalPorts(this.buffer.getInt());
        bean.setNumExternalPorts(this.buffer.getInt());
        UtilStatsBean utilStat = this.getUtilStatsBean(88);
        bean.setInternalUtilStats(utilStat);
        utilStat = this.getUtilStatsBean(176);
        bean.setSendUtilStats(utilStat);
        utilStat = this.getUtilStatsBean(264);
        bean.setRecvUtilStats(utilStat);
        CategoryStatBean errStatBean = this.getCategoryStatBean(352);
        bean.setInternalCategoryStats(errStatBean);
        errStatBean = this.getCategoryStatBean(512);
        bean.setExternalCategoryStats(errStatBean);
        this.buffer.position(672);
        bean.setMaxInternalRate(this.buffer.get());
        bean.setMinInternalRate(this.buffer.get());
        bean.setMaxExternalRate(this.buffer.get());
        bean.setMinExternalRate(this.buffer.get());
        bean.setMaxInternalMBps(this.buffer.getInt());
        bean.setMaxExternalMBps(this.buffer.getInt());
        return bean;
    }
}

