/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.pa;

import com.intel.stl.api.performance.ImageIdBean;
import com.intel.stl.api.performance.PortCountersBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class PortCounters
extends SimpleDatagram<PortCountersBean> {
    private static final int IMAGEID_OFFSET = 24;
    private static final int IMAGEOFFSET_OFFSET = 32;

    public PortCounters() {
        super(248);
    }

    public void setNodeLid(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setPortNumber(byte num) {
        this.buffer.put(4, num);
    }

    public void setFlags(int flag) {
        this.buffer.putInt(8, flag);
    }

    public void setImageNumber(long imageNumber) {
        this.buffer.putLong(24, imageNumber);
    }

    public void setImageOffset(int imageOffset) {
        this.buffer.putInt(32, imageOffset);
    }

    @Override
    public PortCountersBean toObject() {
        this.buffer.clear();
        PortCountersBean bean = new PortCountersBean();
        bean.setNodeLid(this.buffer.getInt());
        bean.setPortNumber(this.buffer.get());
        this.buffer.position(8);
        bean.setFlags(this.buffer.getInt());
        this.buffer.position(24);
        bean.setImageId(new ImageIdBean(this.buffer.getLong(), this.buffer.getInt(), this.buffer.getInt()));
        bean.setPortXmitData(this.buffer.getLong());
        bean.setPortRcvData(this.buffer.getLong());
        bean.setPortXmitPkts(this.buffer.getLong());
        bean.setPortRcvPkts(this.buffer.getLong());
        bean.setPortMulticastXmitPkts(this.buffer.getLong());
        bean.setPortMulticastRcvPkts(this.buffer.getLong());
        bean.setLocalLinkIntegrityErrors(this.buffer.getLong());
        bean.setFmConfigErrors(this.buffer.getLong());
        bean.setPortRcvErrors(this.buffer.getLong());
        bean.setExcessiveBufferOverruns(this.buffer.getLong());
        bean.setPortRcvConstraintErrors(this.buffer.getLong());
        bean.setPortRcvSwitchRelayErrors(this.buffer.getLong());
        bean.setPortXmitDiscards(this.buffer.getLong());
        bean.setPortXmitConstraintErrors(this.buffer.getLong());
        bean.setPortRcvRemotePhysicalErrors(this.buffer.getLong());
        bean.setSwPortCongestion(this.buffer.getLong());
        bean.setPortXmitWait(this.buffer.getLong());
        bean.setPortRcvFECN(this.buffer.getLong());
        bean.setPortRcvBECN(this.buffer.getLong());
        bean.setPortXmitTimeCong(this.buffer.getLong());
        bean.setPortXmitWastedBW(this.buffer.getLong());
        bean.setPortXmitWaitData(this.buffer.getLong());
        bean.setPortRcvBubble(this.buffer.getLong());
        bean.setPortMarkFECN(this.buffer.getLong());
        bean.setLinkErrorRecovery(this.buffer.getInt());
        bean.setLinkDowned(this.buffer.getInt());
        bean.setUncorrectableErrors(this.buffer.get());
        byte byteVal = this.buffer.get();
        bean.setNumLanesDown((byte)(byteVal & 0xF0));
        bean.setLinkQualityIndicator((byte)(byteVal & 7));
        return bean;
    }
}

