/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.CableRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class CableInfoRecord
extends SimpleDatagram<CableRecordBean> {
    public CableInfoRecord() {
        super(72);
    }

    public void setLID(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setPort(byte port) {
        this.buffer.put(4, port);
    }

    public void setDataLength(byte length) {
        int val = length << 1 & 0xFF;
        this.buffer.put(5, (byte)val);
    }

    public void setAddress(short address) {
        int val = address << 4 | this.buffer.getShort(6) & 0xF;
        this.buffer.putShort(6, (short)val);
    }

    public void setPortType(byte portType) {
        int val = this.buffer.getShort(6) & 0xFFF0 | portType & 0xF;
        this.buffer.putShort(6, (short)val);
    }

    public void setData(byte[] data) {
        if (data.length != 64) {
            throw new IllegalArgumentException("Invalid data length. Expect 64, got " + data.length);
        }
        this.buffer.position(8);
        for (byte val : data) {
            this.buffer.put(val);
        }
    }

    @Override
    public CableRecordBean toObject() {
        this.buffer.clear();
        int lid = this.buffer.getInt();
        byte port = this.buffer.get();
        byte length = this.buffer.get();
        int intLength = length >>> 1;
        short shortVal = this.buffer.getShort();
        short address = (short)(shortVal >>> 4);
        byte portType = (byte)(shortVal & 0xF);
        byte[] data = new byte[intLength + 1];
        this.buffer.get(data);
        CableRecordBean bean = new CableRecordBean(lid, port, (byte)intLength, address, portType, data);
        return bean;
    }
}

