/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.CableInfoBean;
import com.intel.stl.api.subnet.CertifiedRateType;
import com.intel.stl.api.subnet.PowerClassType;
import com.intel.stl.common.StringUtils;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class CableInfoStd
extends SimpleDatagram<CableInfoBean> {
    public CableInfoStd() {
        super(128);
    }

    @Override
    public CableInfoBean toObject() {
        CableInfoBean bean = new CableInfoBean();
        bean.setId(this.buffer.get());
        byte byteVal = this.buffer.get();
        bean.setPwrClassLow((byte)(byteVal >>> 6 & 3));
        bean.setExtIdentOther((byte)(byteVal >>> 4 & 3));
        bean.setTxCDRSupported((byteVal & 8) == 8);
        bean.setRxCDRSupported((byteVal & 4) == 4);
        bean.setPwrClassHigh((byte)(byteVal & 3));
        bean.setPowerClass(this.stlCableInfoPowerClassType(bean.getPwrClassLow(), bean.getPwrClassHigh()));
        bean.setConnector(this.buffer.get());
        byte[] byteVals = new byte[8];
        this.buffer.get(byteVals);
        bean.setSpecComp(byteVals);
        bean.setEncode(this.buffer.get());
        bean.setBitRateLow(this.buffer.get());
        bean.setExtRateComp(this.buffer.get());
        bean.setLenSmf(this.buffer.get());
        bean.setOm3Length((this.buffer.get() & 0xFF) * 2);
        bean.setOm2Length(this.buffer.get() & 0xFF);
        bean.setLenOm1(this.buffer.get());
        bean.setLenOm4(this.buffer.get());
        byteVal = this.buffer.get();
        bean.setXmitTech((byte)(byteVal >>> 4 & 0xF));
        bean.setDevTechOther((byte)(byteVal & 0xF));
        boolean isValid = this.isCableLengthValid(bean.getXmitTech(), bean.getConnector());
        bean.setOm4Length(this.getOM4Length(bean.getLenOm4(), isValid));
        byteVals = new byte[16];
        this.buffer.get(byteVals);
        bean.setVendorName(StringUtils.toString(byteVals, 0, 16));
        bean.setExtMod(this.buffer.get());
        byteVals = new byte[3];
        this.buffer.get(byteVals);
        bean.setVendorOui(byteVals);
        byteVals = new byte[16];
        this.buffer.get(byteVals);
        bean.setVendorPn(StringUtils.toString(byteVals, 0, 16));
        byteVals = new byte[2];
        this.buffer.get(byteVals);
        bean.setVendorRev(StringUtils.toString(byteVals, 0, 2));
        byteVals = new byte[2];
        this.buffer.get(byteVals);
        bean.setWaveAtten(byteVals);
        byteVals = new byte[2];
        this.buffer.get(byteVals);
        bean.setWaveTol(byteVals);
        bean.setMaxCaseTemp(this.buffer.get() & 0xFF);
        bean.setCcBase(this.buffer.get());
        this.buffer.position(64);
        bean.setLinkCodes(this.buffer.get());
        byteVal = this.buffer.get();
        bean.setTxInpEqAutoAdp((byteVal & 8) == 8);
        bean.setTxInpEqFixProg((byteVal & 4) == 4);
        bean.setRxOutpEmphFixProg((byteVal & 2) == 2);
        bean.setRxOutpAmplFixProg((byteVal & 1) == 1);
        byteVal = this.buffer.get();
        bean.setTxCDROnOffCtrl((byteVal & 0x80) == 128);
        bean.setRxCDROnOffCtrl((byteVal & 0x40) == 64);
        bean.setTxCdrLol((byteVal & 0x20) == 32);
        bean.setRxCdrLol((byteVal & 0x10) == 16);
        bean.setRxSquelDis((byteVal & 8) == 8);
        bean.setRxOutDis((byteVal & 4) == 4);
        bean.setTxSquelDis((byteVal & 2) == 2);
        bean.setTxSquelchImp((byteVal & 1) == 1);
        byteVal = this.buffer.get();
        bean.setMemPage02Provided((byteVal & 0x80) == 128);
        bean.setMemPage01Provided((byteVal & 0x40) == 64);
        bean.setRateSel((byteVal & 0x20) == 32);
        bean.setTxDis((byteVal & 0x10) == 16);
        bean.setTxFault((byteVal & 8) == 8);
        bean.setTxSquelOmapav((byteVal & 4) == 4);
        bean.setTxLos((byteVal & 2) == 2);
        byteVals = new byte[16];
        this.buffer.get(byteVals);
        bean.setVendorSN(StringUtils.toString(byteVals, 0, 16));
        byteVals = new byte[8];
        this.buffer.get(byteVals);
        String year = StringUtils.toString(byteVals, 0, 2);
        String month = StringUtils.toString(byteVals, 2, 2);
        String day = StringUtils.toString(byteVals, 4, 2);
        String lot = StringUtils.toString(byteVals, 6, 2);
        bean.setDateCode(year, month, day, lot);
        bean.setDiagMonType(this.buffer.get());
        bean.setOptionsEnh(this.buffer.get());
        bean.setBitRateHigh(this.buffer.get());
        bean.setCcExt(this.buffer.get());
        byteVals = new byte[26];
        this.buffer.get(byteVals);
        bean.setVendor(byteVals);
        bean.setOpaCertCable(this.buffer.get());
        bean.setVendor2(this.buffer.get());
        bean.setOpaCertDataRate(this.buffer.get());
        byteVals = new byte[3];
        this.buffer.get(byteVals);
        bean.setVendor3(byteVals);
        bean.setCertCableFlag(this.isStlCableInfoCableCertified(bean.getOpaCertCable()));
        bean.setReachClass(bean.getVendor2());
        bean.setCertDataRate(CertifiedRateType.getCertifiedRateType(bean.getOpaCertDataRate()));
        return bean;
    }

    private boolean isStlCableInfoCableCertified(byte code_cert) {
        return code_cert == -85;
    }

    private boolean isCableLengthValid(byte codeXmit, byte connector) {
        return codeXmit != 8 && (codeXmit > 9 || connector == 35) && codeXmit <= 15;
    }

    private int getOM4Length(byte codeLen, boolean codeValid) {
        if (codeValid) {
            return codeLen & 0xFF;
        }
        return (codeLen & 0xFF) * 2;
    }

    private PowerClassType stlCableInfoPowerClassType(int codeLow, int codeHigh) {
        PowerClassType type = null;
        type = PowerClassType.getPowerClassType(codeHigh, codeLow);
        return type;
    }
}

