/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.SC2VLMTRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class SC2VLMTRecord
extends SimpleDatagram<SC2VLMTRecordBean> {
    public SC2VLMTRecord() {
        super(40);
    }

    public void setLID(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setPort(byte port) {
        this.buffer.put(4, port);
    }

    public void setSC2VLMTData(byte[] data) {
        if (data.length != 32) {
            throw new IllegalArgumentException("Invalid data length. Expect 32, got " + data.length);
        }
        this.buffer.position(8);
        for (byte val : data) {
            this.buffer.put(val);
        }
    }

    @Override
    public SC2VLMTRecordBean toObject() {
        this.buffer.clear();
        int lid = this.buffer.getInt();
        byte port = this.buffer.get();
        this.buffer.position(8);
        byte[] data = new byte[32];
        this.buffer.get(data);
        SC2VLMTRecordBean bean = new SC2VLMTRecordBean(lid, port, data);
        return bean;
    }
}

