/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.messages.adapter.sa;

import com.intel.stl.api.subnet.VLArbTableBean;
import com.intel.stl.api.subnet.VLArbTableRecordBean;
import com.intel.stl.fecdriver.messages.adapter.SimpleDatagram;

public class VLArbTableRecord
extends SimpleDatagram<VLArbTableRecordBean> {
    public VLArbTableRecord() {
        super(264);
    }

    public void setLID(int lid) {
        this.buffer.putInt(0, lid);
    }

    public void setOutputPortNum(byte num) {
        this.buffer.put(4, num);
    }

    public void setBlockNum(byte num) {
        this.buffer.put(5, num);
    }

    public void setElements(byte[] vls, byte[] weights) {
        if (vls.length != 128) {
            throw new IllegalArgumentException("Invalid VLs length. Expected 128, got " + vls.length);
        }
        if (weights.length != 128) {
            throw new IllegalArgumentException("Invalid Weights length. Expected 128, got " + weights.length);
        }
        this.buffer.position(8);
        for (int i = 0; i < 128; ++i) {
            this.buffer.put((byte)(vls[i] & 0x1F));
            this.buffer.put(weights[i]);
        }
    }

    public void setMatrix(int[] matrix) {
        if (matrix.length != 32) {
            throw new IllegalArgumentException("Invalid matrix length. Expected 32, got " + matrix.length);
        }
        this.buffer.position(8);
        for (int i = 0; i < 32; ++i) {
            this.buffer.putInt(matrix[i]);
        }
    }

    @Override
    public VLArbTableRecordBean toObject() {
        this.buffer.clear();
        VLArbTableRecordBean bean = new VLArbTableRecordBean(this.buffer.getInt(), this.buffer.get(), this.buffer.get());
        this.buffer.position(8);
        VLArbTableBean[] data = new VLArbTableBean[128];
        for (int i = 0; i < 128; ++i) {
            data[i] = new VLArbTableBean((byte)(this.buffer.get() & 0x1F), this.buffer.get());
        }
        bean.setVlArbTableElement(data);
        this.buffer.position(8);
        int[] matrix = new int[32];
        for (int i = 0; i < 32; ++i) {
            matrix[i] = this.buffer.getInt();
        }
        bean.setMatrix(matrix);
        return bean;
    }
}

