/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.session;

import com.intel.stl.api.performance.impl.PAHelper;
import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.api.subnet.impl.SAHelper;
import com.intel.stl.fecdriver.ICommand;
import com.intel.stl.fecdriver.IResponse;
import com.intel.stl.fecdriver.IStatement;
import com.intel.stl.fecdriver.dispatcher.IRequestDispatcher;
import com.intel.stl.fecdriver.session.ISession;
import com.intel.stl.fecdriver.session.Statement;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class Session
implements ISession {
    private final List<WeakReference<Statement>> statements = new ArrayList<WeakReference<Statement>>();
    private final IRequestDispatcher dispatcher;
    private SAHelper saHelper;
    private PAHelper paHelper;

    public Session(IRequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public synchronized IStatement createStatement() {
        Statement res = new Statement(this);
        this.addStatement(res);
        return res;
    }

    @Override
    public SAHelper getSAHelper() {
        if (this.saHelper == null) {
            this.saHelper = new SAHelper(this.createStatement());
        }
        return this.saHelper;
    }

    @Override
    public PAHelper getPAHelper() {
        if (this.paHelper == null) {
            this.paHelper = new PAHelper(this.createStatement());
        }
        return this.paHelper;
    }

    @Override
    public synchronized void removeStatement(IStatement statement) {
        Iterator<WeakReference<Statement>> it = this.statements.iterator();
        while (it.hasNext()) {
            WeakReference<Statement> ref = it.next();
            Statement refStatement = (Statement)ref.get();
            if (refStatement == null || !refStatement.equals(statement)) continue;
            it.remove();
            break;
        }
    }

    @Override
    public void cancelFailover() {
        this.dispatcher.cancelFailover();
    }

    @Override
    public void close() {
        ArrayList<WeakReference<Statement>> copy = new ArrayList<WeakReference<Statement>>(this.statements);
        for (WeakReference weakReference : copy) {
            try {
                Statement statement = (Statement)weakReference.get();
                if (statement == null) continue;
                statement.close();
            }
            catch (Exception e) {}
        }
        if (this.saHelper != null) {
            this.saHelper.close();
        }
        if (this.paHelper != null) {
            this.paHelper.close();
        }
        this.dispatcher.removeSession(this);
    }

    @Override
    public SubnetDescription getSubnetDescription() {
        return this.dispatcher.getSubnetDescription();
    }

    protected void addStatement(Statement statement) {
        this.statements.add(new WeakReference<Statement>(statement));
    }

    protected void fireOnRequestTimeout(TimeoutException toe) {
        this.dispatcher.onRequestTimeout(toe);
    }

    protected <E extends IResponse<F>, F> void submitCmd(ICommand<E, F> cmd) {
        this.dispatcher.queueCmd(cmd);
    }
}

