/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.fecdriver.session;

import com.intel.stl.fecdriver.ICommand;
import com.intel.stl.fecdriver.IResponse;
import com.intel.stl.fecdriver.IStatement;
import com.intel.stl.fecdriver.dispatcher.Connection;
import com.intel.stl.fecdriver.dispatcher.ITempRequestDispatcher;
import com.intel.stl.fecdriver.session.Session;
import com.intel.stl.fecdriver.session.TemporaryStatement;

public class TemporarySession
extends Session {
    private final Connection conn;
    private final ITempRequestDispatcher dispatcher;

    public TemporarySession(ITempRequestDispatcher dispatcher, Connection conn) {
        super(dispatcher);
        this.conn = conn;
        this.dispatcher = dispatcher;
    }

    @Override
    public synchronized IStatement createStatement() {
        TemporaryStatement res = new TemporaryStatement(this);
        this.addStatement(res);
        return res;
    }

    @Override
    public void close() {
        this.dispatcher.removeSession(this, this.conn);
    }

    @Override
    protected <E extends IResponse<F>, F> void submitCmd(ICommand<E, F> cmd) {
        if (cmd.getPacket() == null) {
            RuntimeException rte = new RuntimeException("Command has not been processed by a statement");
            cmd.getResponse().setError(rte);
        }
        this.dispatcher.queueCmd(cmd, this.conn);
    }
}

