/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.IConfListener;
import com.intel.stl.ui.admin.IItemEditorListener;
import com.intel.stl.ui.admin.IItemListListener;
import com.intel.stl.ui.admin.InvalidEditException;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.AbstractEditorController;
import com.intel.stl.ui.admin.impl.DeployController;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.view.AbstractConfView;
import com.intel.stl.ui.admin.view.AbstractEditorPanel;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.common.ICancelIndicator;
import com.intel.stl.ui.common.IPageController;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.ValidationModel;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;
import com.intel.stl.ui.publisher.TaskScheduler;
import com.jcraft.jsch.JSchException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfPageController<T, E extends AbstractEditorPanel<T>>
implements IPageController,
IConfListener,
IItemListListener,
IItemEditorListener {
    private static final Logger log = LoggerFactory.getLogger(ConfPageController.class);
    private final String name;
    private final String description;
    private final ImageIcon icon;
    private final AbstractConfView<T, E> view;
    private String helpID;
    protected IManagementApi mgtApi;
    protected TaskScheduler taskScheduler;
    protected final AbstractEditorController<T, E> edtCtr;
    protected ArrayList<Item<T>> orgItems;
    protected DefaultListModel<Item<T>> workingItems;
    protected Item<T> currentItem;
    protected ValidationModel<T> valModel;
    protected DeployController deployController;
    private boolean restart;
    private int busyCount;
    private Future<?> future;

    public ConfPageController(String name, String description, ImageIcon icon, AbstractConfView<T, E> view) {
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.view = view;
        this.installHelp();
        this.workingItems = new DefaultListModel();
        view.setListModel(this.workingItems);
        view.addItemListListener(this);
        view.setConfListener(this);
        E edtPanel = view.getEditorPanel();
        ((AbstractEditorPanel)edtPanel).setEditorListener(this);
        this.edtCtr = this.creatEditorController(edtPanel);
        this.valModel = new ValidationModel();
        this.deployController = new DeployController(view);
    }

    protected void installHelp() {
        String helpId = this.getHelpID();
        if (helpId != null) {
            this.view.enableHelp(true);
            HelpAction helpAction = HelpAction.getInstance();
            helpAction.getHelpBroker().enableHelpOnButton((Component)this.view.getHelpButton(), helpId, helpAction.getHelpSet());
        } else {
            this.view.enableHelp(false);
        }
    }

    public void setHelpID(String helpID) {
        this.helpID = helpID;
        this.installHelp();
    }

    protected abstract String getHelpID();

    protected AbstractEditorController<T, E> creatEditorController(E editorPanel) {
        return new AbstractEditorController(editorPanel);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContext(Context context, IProgressObserver observer) {
        try {
            this.mgtApi = context.getManagementApi();
            this.taskScheduler = context.getTaskScheduler();
            this.deployController.setContext(context, null);
        }
        finally {
            if (observer != null) {
                observer.publishProgress(1.0);
            }
        }
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.LOW;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.LOW;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Component getView() {
        return this.view;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    protected SwingWorker<ArrayList<Item<T>>, Void> getInitWorker() {
        SwingWorker worker = new SwingWorker<ArrayList<Item<T>>, Void>(){

            @Override
            protected ArrayList<Item<T>> doInBackground() throws Exception {
                ArrayList res = ConfPageController.this.initData();
                return res;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    int index;
                    ConfPageController.this.view.showEditorCard();
                    ConfPageController.this.orgItems = (ArrayList)this.get();
                    if (ConfPageController.this.orgItems == null) {
                        return;
                    }
                    ConfPageController.this.view.removeItemListListener(ConfPageController.this);
                    ConfPageController.this.workingItems.clear();
                    int first = -1;
                    for (int i = 0; i < ConfPageController.this.orgItems.size(); ++i) {
                        Item item = ConfPageController.this.orgItems.get(i);
                        if (first == -1 && item.isEditable()) {
                            first = i;
                        }
                        ConfPageController.this.workingItems.addElement(ConfPageController.this.getCopy(item, ChangeState.NONE));
                    }
                    ConfPageController.this.view.addItemListListener(ConfPageController.this);
                    if (ConfPageController.this.currentItem != null && (index = ConfPageController.this.workingItems.indexOf(ConfPageController.this.currentItem)) >= 0) {
                        first = index;
                    }
                    if (first >= 0) {
                        ConfPageController.this.currentItem = ConfPageController.this.workingItems.get(first);
                        ConfPageController.this.currentItem.setState(ChangeState.UPDATE);
                        ConfPageController.this.view.setListModel(ConfPageController.this.workingItems);
                        ConfPageController.this.view.selectItem(first);
                        ConfPageController.this.edtCtr.setItem(ConfPageController.this.currentItem, ConfPageController.this.getWorkingItems());
                    }
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    Util.showError(ConfPageController.this.view, e);
                }
                finally {
                    ConfPageController.this.busyCount -= 1;
                }
            }
        };
        return worker;
    }

    protected abstract ArrayList<Item<T>> initData() throws Exception;

    protected Item<T> getCopy(Item<T> item, ChangeState newState) {
        if (item != null) {
            Item<T> newItem = new Item<T>(item.getId(), item.getName(), this.getCopy(item.getObj()), item.isEditable());
            newItem.setState(newState);
            return newItem;
        }
        Item<T> newItem = new Item<T>(System.currentTimeMillis(), STLConstants.K0016_UNKNOWN.getValue(), this.createObj(), true);
        newItem.setState(newState);
        return newItem;
    }

    protected abstract T getCopy(T var1);

    protected abstract T createObj();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Item<T> getOrgItem(long id) {
        ArrayList<Item<T>> arrayList = this.orgItems;
        synchronized (arrayList) {
            int index = this.indexOfOrgItem(id);
            return this.orgItems.get(index);
        }
    }

    protected int indexOfOrgItem(long id) {
        if (this.orgItems == null) {
            throw new RuntimeException("No item list!");
        }
        ArrayList<Item<T>> arrayList = this.orgItems;
        synchronized (arrayList) {
            for (int i = 0; i < this.orgItems.size(); ++i) {
                Item<T> item = this.orgItems.get(i);
                if (item.getId() != id) continue;
                return i;
            }
            throw new IllegalArgumentException("Couldn't find item with id=" + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Item<T> getWorkingItem(long id) {
        DefaultListModel<Item<T>> defaultListModel = this.workingItems;
        synchronized (defaultListModel) {
            int index = this.indexOfWorkingItem(id);
            return this.workingItems.get(index);
        }
    }

    protected int indexOfWorkingItem(long id) {
        DefaultListModel<Item<T>> defaultListModel = this.workingItems;
        synchronized (defaultListModel) {
            for (int i = 0; i < this.workingItems.size(); ++i) {
                Item<T> item = this.workingItems.get(i);
                if (item.getId() != id) continue;
                return i;
            }
            throw new IllegalArgumentException("Couldn't find item with id=" + id);
        }
    }

    protected Item<T>[] getWorkingItems() {
        Item[] res = new Item[this.workingItems.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.workingItems.get(i);
        }
        return res;
    }

    protected boolean changeCheck() {
        if (this.currentItem == null) {
            return true;
        }
        boolean hasChange = false;
        try {
            this.edtCtr.updateItem(this.currentItem);
        }
        catch (InvalidEditException e) {
            hasChange = true;
        }
        if (hasChange || this.hasChange(this.currentItem)) {
            int index = this.workingItems.indexOf(this.currentItem);
            int option = this.view.confirmDiscard();
            if (option != 0) {
                this.view.selectItem(index);
                return false;
            }
            if (this.currentItem.getState() == ChangeState.ADD) {
                this.currentItem = null;
                this.workingItems.remove(index);
            } else if (this.currentItem.getState() == ChangeState.UPDATE) {
                Item<T> orgItem = this.getOrgItem(this.currentItem.getId());
                Item<T> newItem = this.getCopy(orgItem, ChangeState.NONE);
                this.currentItem = newItem;
                this.workingItems.set(index, newItem);
                this.edtCtr.setItem(this.currentItem, this.getWorkingItems());
            }
            this.view.updateItems();
        }
        return true;
    }

    protected boolean hasChange(Item<T> workingItem) {
        Item<T> orgItem = null;
        try {
            orgItem = this.getOrgItem(workingItem.getId());
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgItem == null || !orgItem.equals(workingItem);
    }

    @Override
    public void onSelect(long id) {
        Item<T> item;
        if (id == -1L) {
            this.edtCtr.setItem(null, this.getWorkingItems());
            this.currentItem = null;
            return;
        }
        if (this.currentItem != null) {
            if (this.currentItem.getId() == id) {
                return;
            }
            if (!this.changeCheck()) {
                return;
            }
        }
        if ((item = this.getWorkingItem(id)).getState() == ChangeState.NONE) {
            item.setState(ChangeState.UPDATE);
        }
        this.edtCtr.setItem(item, this.getWorkingItems());
        this.currentItem = item;
        log.info("Select " + item.getFullDescription());
    }

    @Override
    public void onAdd() {
        if (!this.changeCheck()) {
            return;
        }
        Item<T> newItem = this.getCopy(null, ChangeState.ADD);
        this.currentItem = newItem;
        this.workingItems.addElement(newItem);
        this.view.selectItem(this.workingItems.size() - 1);
        this.edtCtr.setItem(newItem, this.getWorkingItems());
        this.edtCtr.selectItemName();
    }

    @Override
    public void onRemove(final long id) {
        if (!this.changeCheck()) {
            return;
        }
        if (this.currentItem == null || this.currentItem.getState() == ChangeState.ADD) {
            this.view.selectItem(this.workingItems.size() - 1);
            return;
        }
        this.currentItem.setState(ChangeState.REMOVE);
        ValidationDialog vd = new ValidationDialog(this.view, UILabels.STL81101_REMOVE_ITEM.getDescription(this.currentItem.getName())){
            private static final long serialVersionUID = -8807399194554240022L;

            @Override
            public void onCancel() {
                super.onCancel();
                this.close();
            }

            @Override
            public void onOk() {
                super.onOk();
                this.showMessage(STLConstants.K2130_REMOVING.getValue());
                SwingWorker<Integer, Void> worker = ConfPageController.this.getRemoveWorker(this, id);
                worker.execute();
            }
        };
        this.valModel.clear();
        vd.setValidationTableModel(this.valModel);
        vd.enableOk(false);
        vd.showDialog();
        vd.showMessage(STLConstants.K2129_VALIDATING.getValue());
        vd.startProgress();
        ValidationTask<T> vTask = this.getValidationTask(vd, this.currentItem);
        vTask.execute();
    }

    protected SwingWorker<Integer, Void> getRemoveWorker(final ValidationDialog vd, final long id) {
        SwingWorker<Integer, Void> worker = new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() throws Exception {
                int index = ConfPageController.this.indexOfWorkingItem(id);
                Item item = ConfPageController.this.workingItems.get(index);
                ConfPageController.this.removeItemObject(item.getName());
                int orgIndex = ConfPageController.this.indexOfOrgItem(id);
                ConfPageController.this.orgItems.remove(orgIndex);
                ConfPageController.this.workingItems.remove(index);
                if (index >= ConfPageController.this.workingItems.size()) {
                    --index;
                }
                ConfPageController.this.currentItem = null;
                return index;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    Integer index = (Integer)this.get();
                    ConfPageController.this.view.updateItems();
                    ConfPageController.this.view.selectItem(index);
                    vd.reportProgress("Done!");
                    vd.close();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    vd.showMessage(StringUtils.getErrorMessage(e));
                }
                finally {
                    vd.stopProgress();
                }
            }
        };
        return worker;
    }

    protected abstract void removeItemObject(String var1) throws Exception;

    @Override
    public void nameChanged(String name) {
        String oldName = this.currentItem.getName();
        this.currentItem.setName(name);
        this.view.updateItems();
        this.edtCtr.itemNameChanged(oldName, name);
    }

    @Override
    public void onSave() {
        try {
            this.edtCtr.updateItem(this.currentItem);
        }
        catch (InvalidEditException e) {
            Util.showWarningMessage(this.view, e.getMessage());
            return;
        }
        if (!this.hasChange(this.currentItem)) {
            Util.showWarningMessage(this.view, UILabels.STL81112_NO_CHANGES.getDescription());
            return;
        }
        ValidationDialog vd = new ValidationDialog(this.view, UILabels.STL81100_SAVE_ITEM.getDescription(this.currentItem.getName())){
            private static final long serialVersionUID = -8807399194554240022L;

            @Override
            public void onCancel() {
                super.onCancel();
                this.close();
            }

            @Override
            public void onOk() {
                super.onOk();
                this.showMessage(STLConstants.K2128_SAVING.getValue());
                SwingWorker<Void, Void> saveWorker = ConfPageController.this.getSaveWorker(this);
                saveWorker.execute();
            }
        };
        this.valModel.clear();
        vd.setValidationTableModel(this.valModel);
        vd.enableOk(false);
        vd.showDialog();
        vd.showMessage(STLConstants.K2129_VALIDATING.getValue());
        vd.startProgress();
        ValidationTask<T> vTask = this.getValidationTask(vd, this.currentItem);
        vTask.execute();
    }

    protected SwingWorker<Void, Void> getSaveWorker(final ValidationDialog vd) {
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                String oldName = null;
                int index = -1;
                if (ConfPageController.this.currentItem.getState() == ChangeState.UPDATE) {
                    index = ConfPageController.this.indexOfOrgItem(ConfPageController.this.currentItem.getId());
                    Item oldOrgItem = ConfPageController.this.orgItems.get(index);
                    oldName = oldOrgItem.getName();
                }
                ConfPageController.this.saveItemObject(oldName, ConfPageController.this.currentItem.getObj());
                Item newOrgItem = ConfPageController.this.getCopy(ConfPageController.this.currentItem, ChangeState.NONE);
                if (index >= 0) {
                    ConfPageController.this.orgItems.set(index, newOrgItem);
                } else {
                    ConfPageController.this.orgItems.add(newOrgItem);
                }
                ConfPageController.this.currentItem.setState(ChangeState.UPDATE);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    vd.reportProgress("Done!");
                    vd.close();
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    vd.showMessage(StringUtils.getErrorMessage(e));
                }
            }
        };
        return worker;
    }

    protected abstract ValidationTask<T> getValidationTask(ValidationDialog var1, Item<T> var2);

    protected abstract void saveItemObject(String var1, T var2) throws Exception;

    @Override
    public void onReset() {
        int index = this.workingItems.indexOf(this.currentItem);
        Item<T> orgItem = this.getOrgItem(this.currentItem.getId());
        Item<T> newItem = this.getCopy(orgItem, ChangeState.NONE);
        this.workingItems.set(index, newItem);
        this.view.updateItems();
        this.edtCtr.setItem(newItem, this.getWorkingItems());
    }

    @Override
    public void onApply(boolean restart) {
        this.restart = restart;
        try {
            this.edtCtr.updateItem(this.currentItem);
        }
        catch (InvalidEditException e) {
            Util.showWarningMessage(this.view, e.getMessage());
            return;
        }
        if (this.hasChange(this.currentItem)) {
            int index = this.workingItems.indexOf(this.currentItem);
            int option = this.view.confirmDiscard();
            if (option != 0) {
                return;
            }
            if (this.currentItem.getState() == ChangeState.ADD) {
                this.currentItem = null;
                this.workingItems.remove(index);
                this.view.selectItem(this.workingItems.size() - 1);
            } else if (this.currentItem.getState() == ChangeState.UPDATE) {
                Item<T> orgItem = this.getOrgItem(this.currentItem.getId());
                Item<T> newItem = this.getCopy(orgItem, ChangeState.UPDATE);
                this.currentItem = newItem;
                this.workingItems.set(index, newItem);
                this.edtCtr.setItem(newItem, this.getWorkingItems());
            }
            this.view.updateItems();
        }
        if (!this.mgtApi.hasChanges()) {
            Util.showWarningMessage(this.view, UILabels.STL81112_NO_CHANGES.getDescription());
            return;
        }
        this.view.showDeployCard(this.mgtApi.getSubnetDescription());
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void onEnter() {
        if (this.mgtApi == null) {
            this.view.showLoginCard();
            this.view.setMessage(UILabels.STL10116_NOT_INIT.getDescription());
            this.view.setLoginEnabled(false);
            return;
        }
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(true);
        }
        if (this.mgtApi.isConfigReady()) {
            if (!this.view.isShowingDeployCard()) {
                this.view.showEditorCard();
                SwingWorker<ArrayList<Item<T>>, Void> worker = this.getInitWorker();
                worker.execute();
            }
        } else if (this.mgtApi.hasSession()) {
            this.loadConfigFile(null);
        } else {
            this.view.setLoginEnabled(true);
            this.view.setHostNameField(this.mgtApi.getSubnetDescription().getCurrentFE().getHost());
            this.view.setUserNameField(this.mgtApi.getSubnetDescription().getCurrentFE().getSshUserName());
            this.view.showLoginCard();
        }
    }

    @Override
    public void onExit() {
        if (this.mgtApi == null) {
            return;
        }
        this.mgtApi.getSubnetDescription().getCurrentFE().setSshUserName(this.view.getUserNameFieldStr());
        this.mgtApi.getSubnetDescription().getCurrentFE().setSshPortNum(Integer.parseInt(this.view.getPortFieldStr()));
    }

    @Override
    public boolean canExit() {
        return this.busyCount <= 0 && this.deployCheck() && this.changeCheck();
    }

    protected boolean deployCheck() {
        if (this.view.isShowingDeployCard() && this.deployController.isBusy()) {
            int ret = this.deployController.confirmDiscard();
            if (ret == 0) {
                this.deployController.onCancel();
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onRefresh(IProgressObserver observer) {
        if (this.changeCheck()) {
            if (this.mgtApi != null) {
                this.mgtApi.reset();
            }
            this.onEnter();
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public synchronized void onCancelLogin() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        --this.busyCount;
        this.mgtApi.onCancelFetchConfig(this.mgtApi.getSubnetDescription());
        this.view.showLoginCard();
        this.view.clearLoginCard();
    }

    @Override
    public synchronized void prepare(LoginBean credentials) {
        ++this.busyCount;
        int portNum = Integer.parseInt(credentials.getPortNum());
        this.mgtApi.getSubnetDescription().getCurrentFE().setSshPortNum(portNum);
        this.mgtApi.getSubnetDescription().getCurrentFE().setSshUserName(credentials.getUserName());
        this.loadConfigFile(credentials.getPassword());
    }

    protected void loadConfigFile(final char[] password) {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(true);
        }
        final FutureCancelIndicator cancelIndicator = new FutureCancelIndicator();
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConfPageController.this.mgtApi.fetchConfigFile(password);
                    if (!cancelIndicator.isCancelled() && ConfPageController.this.mgtApi.isConfigReady()) {
                        SwingWorker worker = ConfPageController.this.getInitWorker();
                        worker.execute();
                    }
                }
                catch (JSchException e) {
                    log.error("Failed to feaching conf file", (Throwable)e);
                    if (!cancelIndicator.isCancelled()) {
                        ConfPageController.this.view.showLoginCard();
                        ConfPageController.this.view.setMessage(UILabels.STL81111_LOGIN_ERROR.getDescription(StringUtils.getErrorMessage(e)));
                        ConfPageController.this.busyCount -= 1;
                    }
                }
                catch (Exception e) {
                    log.error("Failed to feaching conf file", (Throwable)e);
                    if (!cancelIndicator.isCancelled()) {
                        ConfPageController.this.view.showLoginCard();
                        ConfPageController.this.view.setMessage(StringUtils.getErrorMessage(e));
                        ConfPageController.this.busyCount -= 1;
                    }
                }
                finally {
                    if (!cancelIndicator.isCancelled()) {
                        ConfPageController.this.view.clearLoginCard();
                    }
                }
            }
        };
        this.future = this.taskScheduler.submitToBackground(task);
        cancelIndicator.setFuture(this.future);
    }

    class FutureCancelIndicator
    implements ICancelIndicator {
        private Future<?> future;

        FutureCancelIndicator() {
        }

        public void setFuture(Future<?> future) {
            this.future = future;
        }

        @Override
        public boolean isCancelled() {
            return this.future != null && this.future.isCancelled();
        }
    }
}

