/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.api.subnet.HostInfo;
import com.intel.stl.ui.admin.view.AbstractConfView;
import com.intel.stl.ui.admin.view.DeployHostPanel;
import com.intel.stl.ui.admin.view.DeployPanel;
import com.intel.stl.ui.admin.view.IDeployListener;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.main.Context;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingWorker;

public class DeployController
implements IDeployListener {
    private IManagementApi mgtApi;
    private final AbstractConfView<?, ?> view;
    private final DeployPanel deployPanel;
    private final List<DeployTask> tasks = new ArrayList<DeployTask>();
    private final AtomicInteger finishedTasks = new AtomicInteger();

    public DeployController(AbstractConfView<?, ?> view) {
        this.view = view;
        this.deployPanel = view.getDeployPanel();
        this.deployPanel.setDeployListener(this);
    }

    public void setContext(Context context, IProgressObserver observer) {
        this.mgtApi = context.getManagementApi();
    }

    @Override
    public void onDeploy(DeployHostPanel masterSM, List<DeployHostPanel> standbySMs) {
        this.tasks.clear();
        this.finishedTasks.set(0);
        for (DeployHostPanel sm : standbySMs) {
            if (!sm.isSelected()) continue;
            DeployTask task = new DeployTask(sm);
            this.tasks.add(task);
            task.execute();
            sm.setState(DeployHostPanel.DeployState.RUNNING);
        }
        if (masterSM.isSelected()) {
            DeployTask task = new DeployTask(masterSM);
            this.tasks.add(task);
            task.execute();
            masterSM.setState(DeployHostPanel.DeployState.RUNNING);
        }
        if (this.tasks.isEmpty()) {
            this.deployPanel.setFinished();
        }
    }

    @Override
    public void onCancel() {
        for (DeployTask task : this.tasks) {
            if (task.isDone()) continue;
            task.cancel(true);
            task.getPanel().setErrorMessage(UILabels.STL81115_DEPLOY_CANCELLED.getDescription());
        }
    }

    public boolean isBusy() {
        for (DeployTask task : this.tasks) {
            if (task.isDone()) continue;
            return true;
        }
        return false;
    }

    public int confirmDiscard() {
        return Util.showConfirmDialog(this.view, UILabels.STL81117_ABANDON_DEPLOY.getDescription());
    }

    @Override
    public void onClose() {
        this.view.showEditorCard();
    }

    class DeployTask
    extends SwingWorker<Void, Void> {
        private final DeployHostPanel panel;

        public DeployTask(DeployHostPanel panel) {
            this.panel = panel;
        }

        public DeployHostPanel getPanel() {
            return this.panel;
        }

        @Override
        protected Void doInBackground() throws Exception {
            HostInfo target = this.panel.getHostInfo();
            char[] password = this.panel.getPassword();
            Util.runInEDT(new Runnable(){

                @Override
                public void run() {
                    DeployTask.this.panel.clearPassword();
                }
            });
            DeployController.this.mgtApi.deployTo(password, target);
            Arrays.fill(password, '*');
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            try {
                this.get();
                this.panel.setState(DeployHostPanel.DeployState.SUCCESS);
            }
            catch (InterruptedException e) {
            }
            catch (CancellationException e) {
                this.panel.setErrorMessage(UILabels.STL81115_DEPLOY_CANCELLED.getDescription());
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                Throwable cause = e.getCause();
                while (cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (cause instanceof UnknownHostException) {
                    this.panel.setErrorMessage(UILabels.STL81116_UNKNOWN_HOST.getDescription(cause.getMessage()));
                } else {
                    this.panel.setErrorMessage(StringUtils.getErrorMessage(e));
                }
            }
            finally {
                if (DeployController.this.finishedTasks.incrementAndGet() == DeployController.this.tasks.size()) {
                    DeployController.this.deployPanel.setFinished();
                }
            }
        }
    }
}

