/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.applications;

import com.intel.stl.api.management.applications.IncludeApplication;
import com.intel.stl.ui.admin.impl.IRendererModel;
import com.intel.stl.ui.admin.view.IAttrRenderer;
import com.intel.stl.ui.admin.view.applications.AppSelectRenderer;
import com.intel.stl.ui.admin.view.applications.IncludeApplicationRenderer;
import com.intel.stl.ui.admin.view.applications.MGIDMaskedRenderer;
import com.intel.stl.ui.admin.view.applications.MGIDRangeRenderer;
import com.intel.stl.ui.admin.view.applications.MGIDRenderer;
import com.intel.stl.ui.admin.view.applications.ServiceIDMaskedRenderer;
import com.intel.stl.ui.admin.view.applications.ServiceIDRangeRenderer;
import com.intel.stl.ui.admin.view.applications.ServiceIDRenderer;
import java.util.LinkedHashMap;
import java.util.Map;

public class AppRendererModel
implements IRendererModel {
    private static final Map<String, Class<? extends IAttrRenderer<?>>> map = new LinkedHashMap<String, Class<? extends IAttrRenderer<?>>>(){
        private static final long serialVersionUID = -5530685307771587530L;
        {
            this.put("ServiceID", ServiceIDRenderer.class);
            this.put("ServiceIDRange", ServiceIDRangeRenderer.class);
            this.put("ServiceIDMasked", ServiceIDMaskedRenderer.class);
            this.put("MGID", MGIDRenderer.class);
            this.put("MGIDRange", MGIDRangeRenderer.class);
            this.put("MGIDMasked", MGIDMaskedRenderer.class);
            this.put("Select", AppSelectRenderer.class);
            this.put("IncludeApplication", IncludeApplicationRenderer.class);
        }
    };
    private String[] appNames;

    public void setAppNames(String[] appNames) {
        this.appNames = appNames;
    }

    public String[] updateAppName(String oldName, String newName) {
        for (int i = 0; i < this.appNames.length; ++i) {
            if (!this.appNames[i].equals(oldName)) continue;
            this.appNames[i] = newName;
            break;
        }
        return this.appNames;
    }

    @Override
    public String[] getRendererNames() {
        return map.keySet().toArray(new String[0]);
    }

    @Override
    public IAttrRenderer<?> getRenderer(String name) throws Exception {
        Class<IAttrRenderer<?>> klass = map.get(name);
        if (klass != null) {
            IAttrRenderer<?> res = klass.newInstance();
            this.initRenderer(name, res);
            return res;
        }
        throw new IllegalArgumentException("Unknown renderer '" + name + "'");
    }

    protected void initRenderer(String name, IAttrRenderer<?> renderer) {
        if (name.equals("IncludeApplication")) {
            IncludeApplicationRenderer lsRenderer = (IncludeApplicationRenderer)renderer;
            lsRenderer.setList(IncludeApplication.toArry(this.appNames));
        }
    }
}

