/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import com.intel.stl.api.management.IManagementApi;
import com.intel.stl.api.management.StringNode;
import com.intel.stl.api.management.devicegroups.DeviceGroup;
import com.intel.stl.api.management.virtualfabrics.VirtualFabric;
import com.intel.stl.api.management.virtualfabrics.VirtualFabricException;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.ValidationItem;
import com.intel.stl.ui.common.ValidationModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class DGValidationTask
extends ValidationTask<DeviceGroup> {
    private final IManagementApi mgmtApi;

    public DGValidationTask(ValidationDialog dialog, ValidationModel<DeviceGroup> model, List<Item<DeviceGroup>> items, Item<DeviceGroup> toCheck, IManagementApi mgmtApi) {
        super(dialog, model, items, toCheck);
        this.mgmtApi = mgmtApi;
    }

    @Override
    protected Integer doInBackground() throws Exception {
        ValidationItem<DeviceGroup> vi;
        if (this.toCheck.getState() == ChangeState.NONE) {
            return 0;
        }
        int count = 0;
        if (this.toCheck.getState() == ChangeState.UPDATE || this.toCheck.getState() == ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2124_NAME_CHECK.getValue() + "...");
            vi = this.uniqueNameCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
        }
        if (this.toCheck.getState() != ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2127_REF_CHECK.getValue() + "...");
            vi = this.dgReferenceCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
        }
        if (this.toCheck.getState() != ChangeState.ADD) {
            this.dialog.reportProgress(STLConstants.K2127_REF_CHECK.getValue() + "...");
            vi = this.vfReferenceCheck(this.toCheck);
            if (vi != null) {
                this.publish(vi);
                ++count;
            }
        }
        return count;
    }

    protected ValidationItem<DeviceGroup> uniqueNameCheck(Item<DeviceGroup> toCheck) {
        long id = toCheck.getId();
        String name = toCheck.getObj().getName();
        for (Item item : this.items) {
            if (item.getId() == id || !((DeviceGroup)item.getObj()).getName().equals(name)) continue;
            return new ValidationItem<DeviceGroup>(STLConstants.K2124_NAME_CHECK.getValue(), UILabels.STL81001_DUP_NAME.getDescription(), UILabels.STL81002_DUP_NAME_SUG.getDescription());
        }
        return null;
    }

    protected ValidationItem<DeviceGroup> dgReferenceCheck(Item<DeviceGroup> dg) {
        Callable<DeviceGroup[]> quickFix;
        ValidationItem<DeviceGroup> res;
        final String oldName = this.getDeviceGroup(dg.getId()).getName();
        final String newName = dg.getObj().getName();
        if (dg.getState() != ChangeState.REMOVE && oldName.equals(newName)) {
            return null;
        }
        final List<DeviceGroup> refs = this.getRelatedDGs(oldName);
        if (refs.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(STLConstants.K0408_DEVICE_GROUPS.getValue());
        sb.append(" ");
        for (DeviceGroup ref : refs) {
            if (sb.length() == 0) {
                sb.append("'" + ref.getName() + "'");
                continue;
            }
            sb.append(", '" + ref.getName() + "'");
        }
        if (dg.getState() == ChangeState.REMOVE) {
            res = new ValidationItem<DeviceGroup>(STLConstants.K2127_REF_CHECK.getValue(), UILabels.STL81003_REF_CONF.getDescription(sb.toString()), UILabels.STL81004_REMOVE_REF.getDescription());
            quickFix = new Callable<DeviceGroup[]>(){

                @Override
                public DeviceGroup[] call() throws Exception {
                    DeviceGroup[] newDGs = new DeviceGroup[refs.size()];
                    for (int i = 0; i < refs.size(); ++i) {
                        DeviceGroup dg = ((DeviceGroup)refs.get(i)).copy();
                        dg.removeIncludeGroup(oldName);
                    }
                    DGValidationTask.this.fixedIssue(res);
                    return newDGs;
                }
            };
            res.setQuickFix((Callable<E[]>)quickFix);
            return res;
        }
        if (dg.getState() == ChangeState.UPDATE) {
            res = new ValidationItem(STLConstants.K2127_REF_CHECK.getValue(), UILabels.STL81003_REF_CONF.getDescription(sb.toString()), UILabels.STL81005_UPDATE_REF.getDescription());
            quickFix = new Callable<DeviceGroup[]>(){

                @Override
                public DeviceGroup[] call() throws Exception {
                    DeviceGroup[] newDGs = new DeviceGroup[refs.size()];
                    for (int i = 0; i < refs.size(); ++i) {
                        DeviceGroup dg = ((DeviceGroup)refs.get(i)).copy();
                        int index = dg.indexOfIncludeGroup(oldName);
                        dg.removeIncludeGroup(oldName);
                        dg.insertIncludeGroup(index, newName);
                    }
                    DGValidationTask.this.fixedIssue(res);
                    return newDGs;
                }
            };
            res.setQuickFix(quickFix);
            return res;
        }
        return null;
    }

    private ValidationItem<DeviceGroup> vfReferenceCheck(Item<DeviceGroup> dg) {
        ValidationItem<DeviceGroup> res;
        String oldName = this.getDeviceGroup(dg.getId()).getName();
        String newName = dg.getObj().getName();
        if (dg.getState() != ChangeState.REMOVE && oldName.equals(newName)) {
            return null;
        }
        List<VirtualFabric> refs = this.getRelatedVfs(oldName);
        if (refs.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(STLConstants.K2105_ADM_VFS.getValue());
        sb.append(" ");
        String sep = "'";
        for (VirtualFabric ref : refs) {
            sb.append(sep);
            sb.append(ref.getName());
            sb.append("'");
            sep = ", '";
        }
        if (dg.getState() == ChangeState.REMOVE) {
            res = new ValidationItem<DeviceGroup>(STLConstants.K2127_REF_CHECK.getValue(), UILabels.STL81003_REF_CONF.getDescription(sb.toString()), UILabels.STL81004_REMOVE_REF.getDescription());
            return res;
        }
        if (dg.getState() == ChangeState.UPDATE) {
            res = new ValidationItem(STLConstants.K2127_REF_CHECK.getValue(), UILabels.STL81003_REF_CONF.getDescription(sb.toString()), UILabels.STL81005_UPDATE_REF.getDescription());
            return res;
        }
        return null;
    }

    private List<VirtualFabric> getRelatedVfs(String dgName) {
        ArrayList<VirtualFabric> relVfs = new ArrayList<VirtualFabric>();
        try {
            List<VirtualFabric> vfs = this.mgmtApi.getVirtualFabrics();
            block2: for (VirtualFabric vf : vfs) {
                List<StringNode> vfMems = vf.getMembers();
                for (StringNode mem : vfMems) {
                    if (!mem.getValue().equals(dgName)) continue;
                    relVfs.add(vf);
                    continue block2;
                }
            }
        }
        catch (VirtualFabricException e) {
            e.printStackTrace();
        }
        return relVfs;
    }

    private DeviceGroup getDeviceGroup(long id) {
        for (Item item : this.items) {
            if (item.getId() != id) continue;
            return (DeviceGroup)item.getObj();
        }
        throw new IllegalArgumentException("Couldn't find item by id=" + id);
    }

    private List<DeviceGroup> getRelatedDGs(String name) {
        ArrayList<DeviceGroup> res = new ArrayList<DeviceGroup>();
        for (Item item : this.items) {
            DeviceGroup dg = (DeviceGroup)item.getObj();
            if (!dg.doesIncludeGroup(name)) continue;
            res.add(dg);
            break;
        }
        return res;
    }
}

