/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DescMatcher {
    private static final String validChars = "[A-Za-z0-9\\-=._]";
    private final Pattern pattern;

    public DescMatcher(String pattern) {
        if (pattern.indexOf(58) >= 0) {
            throw new IllegalArgumentException("Invalid format '" + pattern + "'. Please exclude the port pattern string.");
        }
        pattern = this.rangePattern(pattern);
        pattern = pattern.replaceAll("\\*", "[A-Za-z0-9\\-=._]*");
        pattern = pattern.replaceAll("\\?", "[A-Za-z0-9\\-=._]?");
        this.pattern = Pattern.compile("^" + pattern + "$");
    }

    protected String rangePattern(String pattern) {
        int pos1 = pattern.indexOf(91);
        if (pos1 < 0) {
            return pattern;
        }
        int pos2 = pattern.indexOf(93);
        if (pos2 < 0) {
            return pattern;
        }
        String rangeStr = pattern.substring(pos1 + 1, pos2);
        String[] segs = rangeStr.split("-");
        if (segs.length != 2) {
            throw new IllegalArgumentException("Invalid range format '" + rangeStr + "'");
        }
        int min = Integer.parseInt(segs[0].trim());
        int max = Integer.parseInt(segs[1].trim());
        StringBuffer sb = new StringBuffer();
        for (int i = min; i <= max; ++i) {
            if (sb.length() == 0) {
                sb.append("(" + i);
                continue;
            }
            sb.append("|" + i);
        }
        sb.append(")");
        return pattern.substring(0, pos1) + sb.toString() + pattern.substring(pos2 + 1, pattern.length());
    }

    public boolean match(String str) {
        Matcher m = this.pattern.matcher(str);
        return m.matches();
    }
}

