/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.devicegroups;

import com.intel.stl.api.StringUtils;
import com.intel.stl.api.management.IAttribute;
import com.intel.stl.api.management.devicegroups.NodeDesc;
import com.intel.stl.api.management.devicegroups.NodeGUID;
import com.intel.stl.api.management.devicegroups.NodeTypeAttr;
import com.intel.stl.api.management.devicegroups.PortGUID;
import com.intel.stl.api.management.devicegroups.SystemImageGUID;
import com.intel.stl.ui.admin.impl.devicegroups.DescMatcher;
import com.intel.stl.ui.admin.impl.devicegroups.DeviceNode;
import com.intel.stl.ui.admin.impl.devicegroups.PortMatcher;
import com.intel.stl.ui.monitor.TreeNodeType;
import com.intel.stl.ui.monitor.tree.FVResourceNode;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceNodesManager {
    private static final Logger log = LoggerFactory.getLogger(DeviceNodesManager.class);
    private final DeviceNode root;

    public DeviceNodesManager(DeviceNode root) {
        this.root = root;
    }

    public DeviceNode[] getNodes(IAttribute attr) {
        if (attr instanceof NodeTypeAttr) {
            try {
                DeviceNode node = this.getNodeType((NodeTypeAttr)attr);
                return new DeviceNode[]{node};
            }
            catch (Exception e) {
                log.warn("Couldn't find DeviceNode", (Throwable)e);
            }
        } else if (attr instanceof SystemImageGUID) {
            try {
                DeviceNode node = this.getSystemImage(((SystemImageGUID)attr).getGuid());
                return new DeviceNode[]{node};
            }
            catch (Exception e) {
                log.warn("Couldn't find DeviceNode", (Throwable)e);
            }
        } else if (attr instanceof NodeGUID) {
            try {
                DeviceNode node = this.getNode(((NodeGUID)attr).getGuid());
                return new DeviceNode[]{node};
            }
            catch (Exception e) {
                log.warn("Couldn't find DeviceNode", (Throwable)e);
            }
        } else if (attr instanceof PortGUID) {
            try {
                DeviceNode node = this.getPort(((PortGUID)attr).getGuid());
                return new DeviceNode[]{node};
            }
            catch (Exception e) {
                log.warn("Couldn't find DeviceNode", (Throwable)e);
            }
        } else if (attr instanceof NodeDesc) {
            String desc = ((NodeDesc)attr).getValue();
            int pos = desc.indexOf(":");
            if (pos == -1) {
                try {
                    List<DeviceNode> nodes = this.getNodes(desc);
                    return nodes.toArray(new DeviceNode[0]);
                }
                catch (Exception e) {
                    log.warn("Couldn't find DeviceNode", (Throwable)e);
                }
            } else {
                try {
                    List<DeviceNode> nodes = this.getPorts(desc);
                    return nodes.toArray(new DeviceNode[0]);
                }
                catch (Exception e) {
                    log.warn("Couldn't find DeviceNode", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected DeviceNode getNodeType(NodeTypeAttr type) {
        for (FVResourceNode child : this.root.getChildren()) {
            if (!child.getTitle().equals(type.getName())) continue;
            return (DeviceNode)child;
        }
        throw new IllegalArgumentException("Couldn't find DeviceNode " + type);
    }

    protected DeviceNode getSystemImage(long guid) {
        DeviceNode res = this.getSystemImage(this.root, guid);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find SystemImage with SystemImageGUID=" + StringUtils.longHexString(guid));
    }

    private DeviceNode getSystemImage(DeviceNode node, long guid) {
        if (node.getType() == TreeNodeType.SYSTEM_IMAGE) {
            if (node.getGuid() == guid) {
                return node;
            }
            return null;
        }
        for (FVResourceNode child : node.getChildren()) {
            DeviceNode si = this.getSystemImage((DeviceNode)child, guid);
            if (si == null) continue;
            return si;
        }
        return null;
    }

    protected DeviceNode getNode(long guid) {
        DeviceNode res = this.getNode(this.root, guid);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find Node with NodeGUID=" + guid);
    }

    private DeviceNode getNode(DeviceNode node, long guid) {
        if (node.isNode()) {
            if (node.getGuid() == guid) {
                return node;
            }
            return null;
        }
        for (FVResourceNode child : node.getChildren()) {
            DeviceNode res = this.getNode((DeviceNode)child, guid);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    protected List<DeviceNode> getNodes(String desc) {
        DescMatcher matcher = new DescMatcher(desc);
        ArrayList<DeviceNode> res = new ArrayList<DeviceNode>();
        this.getNodes(this.root, matcher, res);
        if (!res.isEmpty()) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find Nodes with description '" + desc + "'");
    }

    private void getNodes(DeviceNode node, DescMatcher matcher, List<DeviceNode> res) {
        if (node.isNode()) {
            if (matcher.match(node.getTitle())) {
                res.add(node);
            }
        } else {
            for (FVResourceNode child : node.getChildren()) {
                this.getNodes((DeviceNode)child, matcher, res);
            }
        }
    }

    protected DeviceNode getPort(long guid) {
        DeviceNode res = this.getPort(this.root, guid);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find Port with PortGUID=" + guid);
    }

    private DeviceNode getPort(DeviceNode node, long guid) {
        if (node.getType() == TreeNodeType.ACTIVE_PORT) {
            if (node.getGuid() == guid) {
                return node;
            }
            return null;
        }
        for (FVResourceNode child : node.getChildren()) {
            DeviceNode res = this.getPort((DeviceNode)child, guid);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    protected List<DeviceNode> getPorts(String desc) {
        String[] segs = desc.split(":");
        if (segs.length != 2) {
            throw new IllegalArgumentException("Unsupported string format '" + desc + "'");
        }
        ArrayList<DeviceNode> res = new ArrayList<DeviceNode>();
        PortMatcher matcher = new PortMatcher(segs[1]);
        List<DeviceNode> nodes = this.getNodes(segs[0]);
        for (DeviceNode node : nodes) {
            for (FVResourceNode port : node.getChildren()) {
                int portNum = port.getId();
                if (!matcher.match(portNum)) continue;
                res.add((DeviceNode)port);
            }
        }
        if (!res.isEmpty()) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find Ports with description '" + desc + "'");
    }

    public IAttribute getAttribute(TreePath path, boolean useGUID) {
        IAttribute res = null;
        DeviceNode dn = (DeviceNode)path.getLastPathComponent();
        if (dn.getType() == TreeNodeType.HCA_GROUP) {
            res = NodeTypeAttr.FI;
        } else if (dn.getType() == TreeNodeType.SWITCH_GROUP) {
            res = NodeTypeAttr.SW;
        } else if (dn.getType() == TreeNodeType.SYSTEM_IMAGE) {
            res = new SystemImageGUID(dn.getGuid());
        } else if (dn.getType() == TreeNodeType.HFI || dn.getType() == TreeNodeType.SWITCH) {
            res = useGUID ? new NodeGUID(dn.getGuid()) : new NodeDesc(dn.getTitle());
        } else if (dn.getType() == TreeNodeType.ACTIVE_PORT) {
            if (useGUID && dn.getGuid() > 0L) {
                res = new PortGUID(dn.getGuid());
            } else {
                String nodeDesc = dn.getParent().getTitle();
                int portNum = dn.getId();
                res = new NodeDesc(nodeDesc + ":[" + portNum + "-" + portNum + "]");
            }
        } else {
            throw new IllegalArgumentException("Unsupported TreeNodeType " + (Object)((Object)dn.getType()));
        }
        return res;
    }

    public List<IAttribute> getAttributes(TreePath[] paths, boolean useGUID) {
        ArrayList<IAttribute> res = new ArrayList<IAttribute>();
        for (TreePath path : paths) {
            res.add(this.getAttribute(path, useGUID));
        }
        HashMap<String, ArrayList<Point>> nodeRanges = new HashMap<String, ArrayList<Point>>();
        for (int i = res.size() - 1; i >= 0; --i) {
            String desc;
            String[] segs;
            IAttribute attr = (IAttribute)res.get(i);
            if (!(attr instanceof NodeDesc) || (segs = (desc = ((NodeDesc)attr).getValue()).split(":")).length != 2) continue;
            res.remove(i);
            String nodeName = segs[0];
            ArrayList<Point> ranges = (ArrayList<Point>)nodeRanges.get(nodeName);
            if (ranges == null) {
                ranges = new ArrayList<Point>();
                nodeRanges.put(nodeName, ranges);
            }
            PortMatcher pm = new PortMatcher(segs[1]);
            List<Point> newRanges = pm.getRanges();
            for (Point newRange : newRanges) {
                this.addRange(ranges, newRange);
            }
        }
        for (String nodeName : nodeRanges.keySet()) {
            List ranges = (List)nodeRanges.get(nodeName);
            Collections.sort(ranges, new Comparator<Point>(){

                @Override
                public int compare(Point o1, Point o2) {
                    if (o1.x > o2.x) {
                        return 1;
                    }
                    if (o1.x < o2.x) {
                        return -1;
                    }
                    return o1.y > o2.y ? 1 : (o1.y < o2.y ? -1 : 0);
                }
            });
            for (Point range : ranges) {
                NodeDesc nd = new NodeDesc(nodeName + ":[" + range.x + "-" + range.y + "]");
                res.add(nd);
            }
        }
        return res;
    }

    protected void addRange(List<Point> src, Point toAdd) {
        boolean merged = false;
        for (Point point : src) {
            if (!this.isConnect(point, toAdd.x) && !this.isConnect(point, toAdd.y)) continue;
            point.x = Math.min(point.x, toAdd.x);
            point.y = Math.max(point.y, toAdd.y);
            merged = true;
            toAdd = point;
        }
        if (!merged) {
            src.add(toAdd);
        }
    }

    protected boolean isConnect(Point range, int val) {
        return val >= range.x - 1 && val <= range.y + 1;
    }
}

