/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.logs;

import com.intel.stl.ui.admin.impl.SMLogModel;
import com.intel.stl.ui.admin.impl.logs.FilterType;
import com.intel.stl.ui.admin.impl.logs.SMLogController;
import com.intel.stl.ui.admin.impl.logs.SearchState;
import com.intel.stl.ui.admin.view.logs.AbstractLogView;
import com.intel.stl.ui.common.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class FilterTask
extends SwingWorker<Void, Void> {
    private final SMLogController parent;
    private final AbstractLogView view;
    private final SMLogModel model;
    private final List<FilterType> keys;

    public FilterTask(SMLogController parent, SMLogModel model, List<FilterType> keys) {
        this.parent = parent;
        this.view = parent.getView();
        this.model = model;
        this.keys = keys;
    }

    @Override
    protected Void doInBackground() throws Exception {
        List<String> doc = this.model.getLogMsg().getEntries();
        List<String> filteredDoc = this.filter(doc, this.keys);
        if (filteredDoc != null) {
            this.model.setFilteredDoc(filteredDoc);
        } else {
            this.model.setFilteredDoc(doc);
        }
        return null;
    }

    protected List<String> filter(List<String> doc, List<FilterType> filters) {
        boolean emptyFilters;
        ArrayList<String> filteredDoc = new ArrayList<String>();
        boolean emptyDoc = doc == null || doc.isEmpty();
        boolean bl = emptyFilters = filters == null || filters.isEmpty();
        if (emptyDoc || emptyFilters) {
            return null;
        }
        for (String line : doc) {
            boolean found = false;
            Iterator<FilterType> it = filters.iterator();
            while (!found && it.hasNext()) {
                FilterType filter = it.next();
                found = line.contains(filter.getName());
            }
            if (!found) continue;
            filteredDoc.add(line);
        }
        return filteredDoc;
    }

    @Override
    protected void done() {
        try {
            this.get();
            this.view.showLogEntry(this.model.getFilteredDoc());
            this.parent.onSearch(SearchState.FILTERED_SEARCH);
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            Util.showError(this.view, e);
            e.printStackTrace();
        }
    }
}

