/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.logs;

import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import java.awt.Color;

public enum FilterType {
    SM(0, STLConstants.K2142_SM.getValue(), UIConstants.INTEL_PALE_BLUE),
    PM(1, STLConstants.K2143_PM.getValue(), UIConstants.INTEL_MEDIUM_BLUE),
    FE(2, STLConstants.K2144_FE.getValue(), UIConstants.INTEL_LIGHT_BLUE),
    WARNINGS(3, STLConstants.K2145_WARN.getValue(), UIConstants.INTEL_YELLOW),
    ERRORS(4, STLConstants.K2146_ERROR.getValue(), UIConstants.INTEL_MEDIUM_RED);

    public static final String[] names;
    private final byte id;
    private final String name;
    private final Color color;

    private FilterType(byte id, String name, Color color) {
        this.id = id;
        this.name = name;
        this.color = color;
    }

    public byte getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static String[] getNames() {
        return names;
    }

    public Color getColor() {
        return this.color;
    }

    public static FilterType getFilter(String name) {
        int i = 0;
        boolean found = false;
        FilterType[] filters = FilterType.values();
        while (!found && i < filters.length) {
            found = filters[i].getName().equals(name);
            i = found ? i : i + 1;
        }
        return found ? filters[i] : null;
    }

    static {
        names = new String[FilterType.values().length];
        for (int i = 0; i < names.length; ++i) {
            FilterType.names[i] = FilterType.values()[i].name;
        }
    }
}

