/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.impl.logs;

import com.intel.stl.ui.common.STLConstants;
import java.util.HashMap;
import java.util.Map;

public enum TextEventType {
    COPY(0, STLConstants.K2159_COPY.getValue()),
    PASTE(1, STLConstants.K2160_PASTE.getValue()),
    HIGHLIGHT(2, STLConstants.K2161_HIGHLIGHT.getValue());

    private static final Map<Byte, TextEventType> typeMap;
    private final byte id;
    private final String value;

    private TextEventType(byte id, String value) {
        this.id = id;
        this.value = value;
    }

    public byte getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public static TextEventType getType(byte id) {
        return typeMap.get(id);
    }

    static {
        typeMap = new HashMap<Byte, TextEventType>(){
            private static final long serialVersionUID = 1L;
            {
                for (TextEventType type : TextEventType.values()) {
                    this.put(type.id, type);
                }
            }
        };
    }
}

