/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.api.subnet.SubnetDescription;
import com.intel.stl.ui.admin.IConfListener;
import com.intel.stl.ui.admin.IItemListListener;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.view.AbstractEditorPanel;
import com.intel.stl.ui.admin.view.DeployPanel;
import com.intel.stl.ui.admin.view.ILoginListener;
import com.intel.stl.ui.admin.view.ItemListPanel;
import com.intel.stl.ui.admin.view.LoginPanel;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import org.jdesktop.swingx.JXLabel;

public abstract class AbstractConfView<T, E extends AbstractEditorPanel<T>>
extends JPanel
implements ILoginListener {
    private static final long serialVersionUID = 8561299073984852795L;
    private static final String DEPLOY = "deploy";
    private static final String LOGIN = "login";
    private final String mainCardName;
    private String currentCard = null;
    protected ItemListPanel<T> selectionPanel;
    protected E editorPanel;
    protected JPanel ctrPanel;
    protected JPanel mainPanel;
    private JPanel loginCardPanel;
    protected JButton deployBtn;
    private IConfListener listener;
    private LoginPanel loginPanel;
    private JPanel deployCardPanel;
    private DeployPanel deployPanel;

    public AbstractConfView(String name) {
        this.setLayout(new CardLayout());
        this.mainCardName = name;
        JPanel panel = this.getEditorCardPanel();
        this.addViewCard(panel, this.mainCardName);
        panel = this.getLoginCardPanel();
        this.addViewCard(panel, LOGIN);
        panel = this.getDeployCardPanel();
        this.addViewCard(panel, DEPLOY);
        this.setViewCard(this.mainCardName);
    }

    protected JPanel getEditorCardPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout(5, 5));
            JSplitPane pane = new JSplitPane(1);
            this.selectionPanel = this.createItemSelectionPanel();
            this.selectionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pane.setLeftComponent(this.selectionPanel);
            JPanel panel = new JPanel(new BorderLayout(5, 5));
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.setOpaque(false);
            this.editorPanel = this.createrEditorPanel();
            ((JComponent)this.editorPanel).setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_TABLE_BORDER_GRAY, 1, true));
            panel.add((Component)this.editorPanel, "Center");
            this.ctrPanel = new JPanel();
            this.ctrPanel.setOpaque(false);
            this.installButtons(this.ctrPanel);
            panel.add((Component)this.ctrPanel, "South");
            pane.setRightComponent(panel);
            this.mainPanel.add((Component)pane, "Center");
        }
        return this.mainPanel;
    }

    private JPanel getLoginCardPanel() {
        if (this.loginCardPanel == null) {
            this.loginCardPanel = new JPanel(new FlowLayout());
            this.loginCardPanel.setBackground(UIConstants.INTEL_WHITE);
            this.loginPanel = new LoginPanel(this){
                private static final long serialVersionUID = 7717352774226770775L;

                @Override
                protected void initLoginPanel() {
                    super.initLoginPanel();
                    this.gc.gridx = 0;
                    ++this.gc.gridy;
                    this.gc.insets = new Insets(0, 10, 5, 10);
                    this.gc.gridwidth = 0;
                    JPanel panel = AbstractConfView.this.createConfNotePanel();
                    this.add((Component)panel, this.gc);
                    this.setPreferredSize(new Dimension(400, 430));
                }
            };
            this.loginCardPanel.add(this.loginPanel);
        }
        return this.loginCardPanel;
    }

    private JPanel createConfNotePanel() {
        JPanel pnlEsmNote = new JPanel(new BorderLayout());
        pnlEsmNote.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_GRAY));
        JXLabel lblEsmNote = new JXLabel(UILabels.STL50220_FM_CONFIG_NOTE.getDescription());
        lblEsmNote.setFont(UIConstants.H5_FONT.deriveFont(1));
        lblEsmNote.setForeground(UIConstants.INTEL_BLUE);
        lblEsmNote.setLineWrap(true);
        lblEsmNote.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlEsmNote.add((Component)lblEsmNote, "Center");
        return pnlEsmNote;
    }

    private JPanel getDeployCardPanel() {
        if (this.deployCardPanel == null) {
            this.deployCardPanel = new JPanel(new BorderLayout());
            this.deployCardPanel.setBackground(UIConstants.INTEL_WHITE);
            this.deployPanel = new DeployPanel();
            this.deployCardPanel.add((Component)this.deployPanel, "North");
        }
        return this.deployCardPanel;
    }

    public DeployPanel getDeployPanel() {
        return this.deployPanel;
    }

    public void setLoginEnabled(boolean b) {
        this.loginPanel.setEnabled(b);
    }

    public void setHostNameField(String host) {
        this.loginPanel.setHostNameField(host);
    }

    public void setUserNameField(String userName) {
        this.loginPanel.setUserNameField(userName);
    }

    public String getUserNameFieldStr() {
        return this.loginPanel.getUserNameFieldStr();
    }

    public String getPortFieldStr() {
        return this.loginPanel.getPortFieldStr();
    }

    protected void addViewCard(Component card, String name) {
        this.add(card, name);
    }

    protected void setViewCard(String name) {
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, name);
        this.repaint();
    }

    @Override
    public void credentialsReady() {
        if (this.listener != null) {
            this.listener.prepare(this.loginPanel.getCredentials());
        }
    }

    @Override
    public void cancelLogin() {
        if (this.listener != null) {
            this.listener.onCancelLogin();
        }
    }

    @Override
    public String getName() {
        return this.mainCardName;
    }

    protected ItemListPanel<T> createItemSelectionPanel() {
        return new ItemListPanel(this.mainCardName);
    }

    protected abstract E createrEditorPanel();

    protected void installButtons(JPanel panel) {
        panel.setLayout(new FlowLayout(4));
        this.deployBtn = ComponentFactory.getIntelActionButton(STLConstants.K2131_DEPLOY.getValue());
        this.deployBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractConfView.this.listener.onApply(false);
            }
        });
        panel.add(this.deployBtn);
    }

    public E getEditorPanel() {
        return this.editorPanel;
    }

    public void enableHelp(boolean b) {
        ((AbstractEditorPanel)this.editorPanel).enableHelp(b);
    }

    public JButton getHelpButton() {
        return ((AbstractEditorPanel)this.editorPanel).getHelpButton();
    }

    public void addItemListListener(IItemListListener listener) {
        this.selectionPanel.addItemListListener(listener);
    }

    public void removeItemListListener(IItemListListener listener) {
        this.selectionPanel.removeItemListListener(listener);
    }

    public void setConfListener(IConfListener listener) {
        this.listener = listener;
    }

    public void setListModel(ListModel<Item<T>> model) {
        this.selectionPanel.setListModel(model);
        this.selectionPanel.repaint();
    }

    public void selectItem(int index) {
        this.selectionPanel.selectItem(index);
        this.revalidate();
        this.repaint();
    }

    public void updateItems() {
        this.selectionPanel.repaint();
    }

    public int confirmDiscard() {
        return Util.showConfirmDialog(this, UILabels.STL50081_ABANDON_CHANGES_MESSAGE.getDescription());
    }

    public void showLoginCard() {
        CardLayout cl = (CardLayout)this.getLayout();
        this.loginPanel.showProgress(false);
        this.loginPanel.setMessage(null);
        this.loginPanel.setHostFieldEnabled(false);
        cl.show(this, LOGIN);
        this.currentCard = LOGIN;
        this.repaint();
    }

    public void showDeployCard(SubnetDescription subnet) {
        this.deployPanel.setSubnet(subnet);
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, DEPLOY);
        this.currentCard = DEPLOY;
        this.repaint();
    }

    public boolean isShowingDeployCard() {
        return this.currentCard == DEPLOY;
    }

    public void showEditorCard() {
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, this.mainCardName);
        this.currentCard = this.mainCardName;
        this.repaint();
    }

    public String getCurrentCard() {
        return this.currentCard;
    }

    public void clearLoginCard() {
        this.loginPanel.clearLoginData();
    }

    public void setMessage(String msg) {
        this.loginPanel.setMessage(msg);
    }
}

