/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view;

import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.ValidationModel;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.FVHeaderRenderer;
import com.intel.stl.ui.common.view.OptionDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class ValidationDialog
extends OptionDialog {
    private static final long serialVersionUID = -6303832281521441888L;
    private JPanel mainPanel;
    private JLabel msgLabel;
    private JXTable validateTable;

    public ValidationDialog(Component owner, String title) {
        super(owner, title, 2);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout(5, 5));
            this.msgLabel = ComponentFactory.getH3Label(null, 0);
            this.msgLabel.setHorizontalAlignment(10);
            this.mainPanel.add((Component)this.msgLabel, "North");
            this.validateTable = this.createTable();
            JScrollPane pane = new JScrollPane((Component)this.validateTable);
            this.validateTable.setPreferredScrollableViewportSize(new Dimension(100, 100));
            this.mainPanel.add((Component)pane, "Center");
        }
        return this.mainPanel;
    }

    protected JXTable createTable() {
        final JXTable table = new JXTable();
        table.setVisibleRowCount(5);
        table.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.INTEL_WHITE, (Color)UIConstants.INTEL_TABLE_ROW_GRAY)});
        table.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -5487920883938816871L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                comp.setToolTipText(value.toString());
                return comp;
            }
        });
        table.setDefaultRenderer(Boolean.class, new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Callable quickFix = (Callable)value;
                if (quickFix != null) {
                    JButton button = new JButton("Quick Fix");
                    return button;
                }
                return new JLabel("N/A");
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point = e.getPoint();
                int row = table.rowAtPoint(point);
                int col = table.columnAtPoint(point);
                if (row == -1 || col == -10) {
                    return;
                }
                Object val = table.getValueAt(row, col);
                if (val != null) {
                    Callable quickFix = (Callable)val;
                    try {
                        quickFix.call();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        ValidationDialog.this.showMessage(StringUtils.getErrorMessage(e1));
                    }
                }
            }
        });
        return table;
    }

    @Override
    protected void setSize() {
        this.setSize(600, 270);
    }

    public void setValidationTableModel(ValidationModel<?> model) {
        if (this.validateTable != null) {
            this.validateTable.setModel(model);
            JTableHeader header = this.validateTable.getTableHeader();
            header.setDefaultRenderer(new FVHeaderRenderer(this.validateTable));
        }
    }

    public void showMessage(String text) {
        if (this.msgLabel != null) {
            this.msgLabel.setText(text);
            this.revalidate();
        }
    }

    @Override
    protected void onClose() {
    }

    public void updateIssues() {
        this.validateTable.packAll();
    }
}

