/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.devicegroups;

import com.intel.stl.api.StringUtils;
import com.intel.stl.ui.admin.impl.devicegroups.DeviceNode;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.view.ComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeSelectionModel;

public class DevicesPanel
extends JPanel {
    private static final long serialVersionUID = 1350511780844381213L;
    public static final String GUID = "guid";
    public static final String DESC = "desc";
    private JPanel ctrPanel;
    private JCheckBox guidBox;
    private JTree tree;
    private boolean showGUID;

    public DevicesPanel() {
        this.initComponent();
    }

    protected void initComponent() {
        this.setLayout(new BorderLayout());
        JPanel panel = this.getControlPanel();
        this.add((Component)panel, "North");
        JTree tree = this.getTree();
        JScrollPane pane = new JScrollPane(tree);
        this.add((Component)pane, "Center");
    }

    protected JPanel getControlPanel() {
        if (this.ctrPanel == null) {
            this.ctrPanel = new JPanel(new FlowLayout(3, 5, 2));
            this.ctrPanel.setOpaque(false);
            JLabel label = ComponentFactory.getH4Label(STLConstants.K2135_OPTIONS.getValue(), 0);
            this.ctrPanel.add(label);
            this.guidBox = new JCheckBox(STLConstants.K2136_USE_GUID.getValue());
            this.guidBox.setForeground(UIConstants.INTEL_DARK_GRAY);
            this.guidBox.setFont(UIConstants.H4_FONT);
            this.ctrPanel.add(this.guidBox);
        }
        return this.ctrPanel;
    }

    protected JTree getTree() {
        if (this.tree == null) {
            this.tree = new JTree();
            this.tree.setCellRenderer(new DescRenderer());
            this.tree.setRootVisible(false);
            this.tree.setShowsRootHandles(true);
        }
        return this.tree;
    }

    public void setTreeModel(TreeModel model) {
        this.tree.setModel(model);
    }

    public void addOptionsListener(ActionListener listener) {
        this.guidBox.addActionListener(listener);
    }

    public void removeOptionsListener(ActionListener listener) {
        this.guidBox.removeActionListener(listener);
    }

    public void setSelectionModel(TreeSelectionModel selectionModel) {
        this.tree.setSelectionModel(selectionModel);
    }

    public void showGUID(boolean b) {
        if (this.showGUID != b) {
            this.showGUID = b;
            this.tree.setCellRenderer(b ? new GUIRenderer() : new DescRenderer());
        }
    }

    class DescRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3313950353093825301L;

        DescRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DeviceNode) {
                DeviceNode node = (DeviceNode)value;
                label.setIcon(node.getType().getIcon());
                label.setEnabled(!node.isSelected());
            }
            return label;
        }
    }

    class GUIRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3313950353093825301L;

        GUIRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DeviceNode) {
                DeviceNode node = (DeviceNode)value;
                label.setIcon(node.getType().getIcon());
                label.setEnabled(!node.isSelected());
                if (node.getGuid() != 0L) {
                    label.setText(StringUtils.longHexString(node.getGuid()));
                }
            }
            return label;
        }
    }
}

