/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.logs;

import com.intel.stl.api.logs.LogConfigType;
import com.intel.stl.ui.admin.impl.SMLogModel;
import com.intel.stl.ui.admin.impl.logs.FilterType;
import com.intel.stl.ui.admin.impl.logs.ILogController;
import com.intel.stl.ui.admin.impl.logs.ILogViewListener;
import com.intel.stl.ui.admin.impl.logs.SearchKey;
import com.intel.stl.ui.admin.impl.logs.SearchPositionBean;
import com.intel.stl.ui.admin.impl.logs.SearchState;
import com.intel.stl.ui.admin.impl.logs.TextEventType;
import com.intel.stl.ui.admin.view.ILoginListener;
import com.intel.stl.ui.admin.view.logs.LogViewType;
import com.intel.stl.ui.admin.view.logs.SMLoginView;
import com.intel.stl.ui.admin.view.logs.TextMenuPanel;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UIImages;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.WidgetName;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.SafeNumberField;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.main.HelpAction;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public abstract class AbstractLogView
extends JPanel {
    private static final long serialVersionUID = 5538100358303437466L;
    private final long MIN_NUM_LINES = 1L;
    private final long MAX_NUM_LINES = 1000L;
    private SMLoginView smLoginView;
    protected JPanel pnlRefresh;
    private JButton btnHelp;
    private JButton btnRefresh;
    private JLabel lblRefreshRunning;
    private SafeNumberField<Long> txtFldLinesPerPage;
    private JComboBox<Long> cboxLinesPerPageValue;
    private JLabel lblTotalLinesValue;
    private JLabel lblStartLineValue;
    private JLabel lblEndLineValue;
    private JLabel lblRangeDelimiter;
    private JLabel lblFileNameValue;
    private JButton btnPrevious;
    private JButton btnNext;
    private JTextField txtfldSearch;
    protected String lastSearchKey;
    private JButton btnSearch;
    private JButton btnCancelSearch;
    private final CardLayout cardLayout = new CardLayout();
    protected ILogViewListener logViewListener;
    private ILogController logController;
    private long numLinesRequested = 100L;
    private JCheckBox chkboxSM;
    private JCheckBox chkboxPM;
    private JCheckBox chkboxFE;
    private JCheckBox chkboxWarnings;
    private JCheckBox chkboxErrors;
    private final List<JCheckBox> chkboxFilterList = new ArrayList<JCheckBox>();
    private JLabel lblPageRunning;
    protected JTextComponent textContent;
    private int numLineIndex;
    private DocumentListener numLineListener;
    private JButton[] buttons;
    private boolean[] lastButtonState;
    private JLabel lblNumMatchesValue;
    protected TextMenuPanel pnlSearchMenu;
    private boolean enableUserActions;
    protected ILoginListener loginListener;
    private String currentCardName;

    public AbstractLogView() {
        this.createNumLineListener();
        this.initComponent();
    }

    protected void createNumLineListener() {
        this.numLineListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractLogView.this.numLineIndex = AbstractLogView.this.cboxLinesPerPageValue.getSelectedIndex();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractLogView.this.numLineIndex = AbstractLogView.this.cboxLinesPerPageValue.getSelectedIndex();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractLogView.this.numLineIndex = AbstractLogView.this.cboxLinesPerPageValue.getSelectedIndex();
            }
        };
    }

    protected void initComponent() {
        this.setLayout(this.cardLayout);
        JPanel pnlLogCard = new JPanel();
        pnlLogCard.setLayout(new BorderLayout(5, 5));
        pnlLogCard.setOpaque(false);
        pnlLogCard.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIConstants.INTEL_BORDER_GRAY, 1, true), BorderFactory.createEmptyBorder(2, 5, 2, 2)));
        JPanel pnlMain = this.createMainPanel();
        pnlLogCard.add((Component)pnlMain, "North");
        pnlLogCard.add(this.getMainComponent(), "Center");
        this.add((Component)pnlLogCard, LogViewType.SM_LOG.getValue());
        JPanel pnlLoginCard = new JPanel(new FlowLayout());
        this.smLoginView = new SMLoginView();
        pnlLoginCard.setBackground(UIConstants.INTEL_WHITE);
        if (this.smLoginView != null) {
            this.smLoginView.enableForm(false);
        }
        pnlLoginCard.add(this.smLoginView);
        this.add((Component)pnlLoginCard, LogViewType.LOGIN.getValue());
        this.buttons = new JButton[]{this.btnRefresh, this.btnNext, this.btnPrevious};
        this.lastButtonState = new boolean[]{this.btnRefresh.isEnabled(), this.btnNext.isEnabled(), this.btnPrevious.isEnabled()};
        this.textContent = this.getTextContent();
        this.textContent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String selected;
                if (e.getClickCount() > 1 && (selected = AbstractLogView.this.textContent.getSelectedText()) != null && !selected.isEmpty()) {
                    AbstractLogView.this.txtfldSearch.setText(selected);
                    AbstractLogView.this.logViewListener.onSearch(SearchState.MARKED_SEARCH);
                }
            }
        });
        HelpAction helpAction = HelpAction.getInstance();
        helpAction.getHelpBroker().enableHelpOnButton((Component)this.btnHelp, helpAction.getAdminLogViewer(), helpAction.getHelpSet());
    }

    protected JPanel createMainPanel() {
        JPanel pnlMain = new JPanel();
        pnlMain.setLayout(new BorderLayout());
        JPanel pnlControl = this.createControlPanel();
        JPanel pnlStatus = this.createStatusPanel();
        pnlMain.add((Component)pnlControl, "North");
        pnlMain.add((Component)pnlStatus, "South");
        return pnlMain;
    }

    protected JPanel createControlPanel() {
        JPanel pnlControl = new JPanel();
        pnlControl.setBackground(UIConstants.INTEL_WHITE);
        pnlControl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets = new Insets(2, 5, 2, 5);
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        JPanel pnlFilters = this.createFiltersPanel();
        pnlControl.add((Component)pnlFilters, gc);
        this.pnlRefresh = this.createRefreshPanel();
        pnlControl.add((Component)this.pnlRefresh, gc);
        JPanel pnlSearch = this.createSearchPanel();
        pnlControl.add((Component)pnlSearch, gc);
        gc.weightx = 0.0;
        JPanel pnlNav = this.createNavPanel();
        pnlControl.add((Component)pnlNav, gc);
        JButton btnConfig = ComponentFactory.getImageButton(UIImages.SETTING_ICON.getImageIcon());
        btnConfig.setToolTipText(STLConstants.K2166_CONFIGURE_LOG_HOST.getValue());
        btnConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AbstractLogView.this.logViewListener.onConfigure();
            }
        });
        btnConfig.setName(WidgetName.ADMIN_LOGS_CONFIGURE_BUTTON.name());
        pnlControl.add((Component)btnConfig, gc);
        this.btnHelp = ComponentFactory.getImageButton(UIImages.HELP_ICON.getImageIcon());
        this.btnHelp.setToolTipText(STLConstants.K0037_HELP.getValue());
        this.btnHelp.setName(WidgetName.ADMIN_LOGS_HELP_BUTTON.name());
        pnlControl.add(this.btnHelp);
        return pnlControl;
    }

    protected JPanel createStatusPanel() {
        JPanel pnlStatus = new JPanel();
        pnlStatus.setBackground(UIConstants.INTEL_WHITE);
        pnlStatus.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 5, 5, 5);
        gc.weightx = 1.0;
        gc.gridwidth = 1;
        gc.anchor = 17;
        JPanel pnlFileName = this.createFileNamePanel();
        pnlStatus.add((Component)pnlFileName, gc);
        gc.anchor = 10;
        JPanel pnlTotalLines = this.createTotalLinesPanel();
        pnlStatus.add((Component)pnlTotalLines, gc);
        JPanel pnlNumMatches = this.createNumMatchesPanel();
        pnlStatus.add((Component)pnlNumMatches, gc);
        gc.anchor = 13;
        JPanel pnlLineRange = this.createLineRangePanel();
        pnlStatus.add((Component)pnlLineRange, gc);
        return pnlStatus;
    }

    protected JPanel createFileNamePanel() {
        JPanel pnlStatus = new JPanel();
        pnlStatus.setBackground(UIConstants.INTEL_WHITE);
        pnlStatus.setLayout(new BoxLayout(pnlStatus, 0));
        JLabel lblFileName = ComponentFactory.getFieldLabel(STLConstants.K2154_FILE_NAME.getValue() + ":");
        lblFileName.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        lblFileName.setName(WidgetName.ADMIN_LOGS_FILE_NAME_LABEL.name());
        pnlStatus.add(lblFileName);
        this.lblFileNameValue = ComponentFactory.deriveLabel(ComponentFactory.getH6Label("", 0), false, 200);
        this.lblFileNameValue.setName(WidgetName.ADMIN_LOGS_FILE_NAME_VALUE.name());
        pnlStatus.add(this.lblFileNameValue);
        return pnlStatus;
    }

    protected JPanel createTotalLinesPanel() {
        JPanel pnlTotalLines = new JPanel();
        pnlTotalLines.setBackground(UIConstants.INTEL_WHITE);
        pnlTotalLines.setLayout(new BoxLayout(pnlTotalLines, 0));
        JLabel lblTotalLines = ComponentFactory.getFieldLabel(STLConstants.K2151_TOTAL_LINES.getValue() + ":");
        lblTotalLines.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        lblTotalLines.setName(WidgetName.ADMIN_LOGS_TOTAL_LINES_LABEL.name());
        pnlTotalLines.add(lblTotalLines);
        this.lblTotalLinesValue = ComponentFactory.getH6Label("", 0);
        this.lblTotalLinesValue.setName(WidgetName.ADMIN_LOGS_TOTAL_LINES_VALUE.name());
        pnlTotalLines.add(this.lblTotalLinesValue);
        return pnlTotalLines;
    }

    protected JPanel createNumMatchesPanel() {
        JPanel pnlNumMatches = new JPanel();
        pnlNumMatches.setBackground(UIConstants.INTEL_WHITE);
        pnlNumMatches.setLayout(new BoxLayout(pnlNumMatches, 0));
        JLabel lblNumMatches = ComponentFactory.getFieldLabel(STLConstants.K2158_NUM_MATCHES.getValue() + ":");
        lblNumMatches.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        lblNumMatches.setName(WidgetName.ADMIN_LOGS_NUM_MATCHES_LABEL.name());
        pnlNumMatches.add(lblNumMatches);
        this.lblNumMatchesValue = ComponentFactory.getH6Label("", 0);
        this.lblNumMatchesValue.setName(WidgetName.ADMIN_LOGS_NUM_MATCHES_VALUE.name());
        pnlNumMatches.add(this.lblNumMatchesValue);
        return pnlNumMatches;
    }

    protected JPanel createLineRangePanel() {
        JPanel pnlLineRange = new JPanel();
        pnlLineRange.setBackground(UIConstants.INTEL_WHITE);
        pnlLineRange.setLayout(new BoxLayout(pnlLineRange, 0));
        JLabel lblLineRange = ComponentFactory.getFieldLabel(STLConstants.K2155_LINE_RANGE.getValue() + ":");
        lblLineRange.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        lblLineRange.setName(WidgetName.ADMIN_LOGS_LINE_RANGE_LABEL.name());
        pnlLineRange.add(lblLineRange);
        this.lblStartLineValue = ComponentFactory.getH6Label("", 0);
        this.lblStartLineValue.setName(WidgetName.ADMIN_LOGS_LINE_RANGE_START.name());
        this.lblRangeDelimiter = ComponentFactory.getH6Label(STLConstants.K2156_RANGE_DELIMITER.getValue(), 0);
        this.lblEndLineValue = ComponentFactory.getH6Label("", 0);
        this.lblEndLineValue.setName(WidgetName.ADMIN_LOGS_LINE_RANGE_END.name());
        pnlLineRange.add(this.lblStartLineValue);
        pnlLineRange.add(this.lblRangeDelimiter);
        pnlLineRange.add(this.lblEndLineValue);
        return pnlLineRange;
    }

    protected JPanel createFiltersPanel() {
        JPanel pnlFilters = new JPanel();
        pnlFilters.setToolTipText(STLConstants.K2170_SHOW_SELECTIONS.getValue());
        pnlFilters.setBackground(UIConstants.INTEL_WHITE);
        pnlFilters.setBorder(BorderFactory.createTitledBorder(STLConstants.K2147_FILTERS.getValue()));
        pnlFilters.setLayout(new BoxLayout(pnlFilters, 0));
        this.chkboxSM = ComponentFactory.getIntelCheckBox(FilterType.SM.getName());
        this.chkboxSM.setName(WidgetName.ADMIN_LOGS_FILTERS_SM.name());
        this.chkboxFilterList.add(this.chkboxSM);
        this.chkboxPM = ComponentFactory.getIntelCheckBox(FilterType.PM.getName());
        this.chkboxPM.setName(WidgetName.ADMIN_LOGS_FILTERS_PM.name());
        this.chkboxFilterList.add(this.chkboxPM);
        this.chkboxFE = ComponentFactory.getIntelCheckBox(FilterType.FE.getName());
        this.chkboxFE.setName(WidgetName.ADMIN_LOGS_FILTERS_FE.name());
        this.chkboxFilterList.add(this.chkboxFE);
        this.chkboxWarnings = ComponentFactory.getIntelCheckBox(FilterType.WARNINGS.getName());
        this.chkboxWarnings.setName(WidgetName.ADMIN_LOGS_FILTERS_WARN.name());
        this.chkboxFilterList.add(this.chkboxWarnings);
        this.chkboxErrors = ComponentFactory.getIntelCheckBox(FilterType.ERRORS.getName());
        this.chkboxErrors.setName(WidgetName.ADMIN_LOGS_FILTERS_ERROR.name());
        this.chkboxFilterList.add(this.chkboxErrors);
        for (JCheckBox chkbox : this.chkboxFilterList) {
            chkbox.setSelected(false);
            chkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractLogView.this.logViewListener.onFilter();
                }
            });
            pnlFilters.add(chkbox);
        }
        return pnlFilters;
    }

    protected JPanel createRefreshPanel() {
        JPanel pnlRefresh = new JPanel();
        pnlRefresh.setBackground(UIConstants.INTEL_WHITE);
        pnlRefresh.setBorder(BorderFactory.createTitledBorder(STLConstants.K0107_REFRESH.getValue()));
        pnlRefresh.setLayout(new BoxLayout(pnlRefresh, 0));
        JLabel lblLinesPerPage = ComponentFactory.getFieldLabel(STLConstants.K2150_LINES_PER_PAGE.getValue() + ":");
        lblLinesPerPage.setAlignmentX(4.0f);
        lblLinesPerPage.setName(WidgetName.ADMIN_LOGS_LPP_LABEL.name());
        pnlRefresh.setMaximumSize(new Dimension(225, 44));
        pnlRefresh.add(lblLinesPerPage);
        this.txtFldLinesPerPage = new SafeNumberField<Long>(new DecimalFormat("###"), 1L, true, 1000L, true);
        this.txtFldLinesPerPage.setValidChars("0123456789");
        this.txtFldLinesPerPage.setColumns(10);
        this.txtFldLinesPerPage.setName(WidgetName.ADMIN_LOGS_LPP_TEXT_FIELD.name());
        this.cboxLinesPerPageValue = ComponentFactory.createComboBox(new Long[]{100L, 300L, 500L, 1000L}, this.txtFldLinesPerPage, this.numLineListener);
        this.cboxLinesPerPageValue.setEditable(true);
        this.cboxLinesPerPageValue.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    AbstractLogView.this.onEndOfPage();
                }
            }
        });
        this.cboxLinesPerPageValue.setName(WidgetName.ADMIN_LOGS_LPP_COMBO_BOX.name());
        this.btnRefresh = ComponentFactory.getImageButton(UIImages.REFRESH.getImageIcon());
        this.btnRefresh.setToolTipText(STLConstants.K0107_REFRESH.getValue());
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLogView.this.onEndOfPage();
            }
        });
        this.btnRefresh.setName(WidgetName.ADMIN_LOGS_LPP_REFRESH_BUTTON.name());
        this.lblRefreshRunning = new JLabel();
        this.lblRefreshRunning.setIcon(UIImages.INVISIBLE.getImageIcon());
        this.lblRefreshRunning.setName(WidgetName.ADMIN_LOGS_LPP_REFRESH_RUNNING.name());
        pnlRefresh.add(Box.createHorizontalStrut(5));
        pnlRefresh.add(this.cboxLinesPerPageValue);
        pnlRefresh.add(Box.createHorizontalStrut(5));
        pnlRefresh.add(this.btnRefresh);
        pnlRefresh.add(this.lblRefreshRunning);
        return pnlRefresh;
    }

    protected JPanel createSearchPanel() {
        JPanel pnlSearch = new JPanel();
        pnlSearch.setBackground(UIConstants.INTEL_WHITE);
        pnlSearch.setBorder(BorderFactory.createTitledBorder(STLConstants.K2153_SEARCH.getValue()));
        pnlSearch.setLayout(new BoxLayout(pnlSearch, 0));
        pnlSearch.setMaximumSize(new Dimension(250, 44));
        this.txtfldSearch = new JTextField();
        this.txtfldSearch.setPreferredSize(new Dimension(200, 10));
        this.txtfldSearch.setMinimumSize(this.txtfldSearch.getPreferredSize());
        this.txtfldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    AbstractLogView.this.logViewListener.onSearch(SearchState.STANDARD_SEARCH);
                }
            }
        });
        ArrayList<TextEventType> eventTypes = new ArrayList<TextEventType>(Arrays.asList(TextEventType.PASTE));
        this.pnlSearchMenu = new TextMenuPanel(eventTypes);
        this.txtfldSearch.addMouseListener(this.pnlSearchMenu);
        this.txtfldSearch.setName(WidgetName.ADMIN_LOGS_SEARCH_TEXT_FIELD.name());
        pnlSearch.add(this.txtfldSearch);
        this.btnSearch = ComponentFactory.getImageButton(UIImages.SEARCH.getImageIcon());
        this.btnSearch.setToolTipText(STLConstants.K2153_SEARCH.getValue());
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLogView.this.logViewListener.onSearch(SearchState.STANDARD_SEARCH);
            }
        });
        this.btnSearch.setName(WidgetName.ADMIN_LOGS_SEARCH_BUTTON.name());
        pnlSearch.add(this.btnSearch);
        this.btnCancelSearch = ComponentFactory.getImageButton(UIImages.CLOSE_GRAY.getImageIcon());
        this.btnCancelSearch.setToolTipText(STLConstants.K2169_CLEAR_SEARCH.getValue());
        this.btnCancelSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLogView.this.txtfldSearch.setText("");
            }
        });
        this.btnCancelSearch.setName(WidgetName.ADMIN_LOGS_SEARCH_CANCEL_BUTTON.name());
        pnlSearch.add(this.btnCancelSearch);
        return pnlSearch;
    }

    public void enableSearch(boolean b) {
        this.btnSearch.setSelected(true);
        this.btnSearch.setEnabled(b);
    }

    public void enableControlPanel(boolean b) {
        this.cboxLinesPerPageValue.setEnabled(b);
        for (JCheckBox chkbox : this.chkboxFilterList) {
            chkbox.setEnabled(b);
        }
    }

    public String getSearchKey() {
        return this.txtfldSearch.getText();
    }

    public void setSearchField(String value) {
        this.txtfldSearch.setText(value);
    }

    public String getLastSearchKey() {
        return this.lastSearchKey;
    }

    public void saveLastSearchKey() {
        this.lastSearchKey = this.getSearchKey();
    }

    public void resetSearchField() {
        this.txtfldSearch.setText("");
    }

    public void resetLogin() {
        this.smLoginView.resetLogin();
    }

    public String getDocument() {
        return this.textContent.getText().replaceAll("\\n", " ").trim();
    }

    protected JPanel createNavPanel() {
        JPanel pnlNav = new JPanel();
        pnlNav.setBackground(UIConstants.INTEL_WHITE);
        pnlNav.setPreferredSize(new Dimension(100, 20));
        pnlNav.setMinimumSize(pnlNav.getPreferredSize());
        pnlNav.setLayout(new BoxLayout(pnlNav, 0));
        this.btnPrevious = ComponentFactory.getIntelActionButton(new AbstractAction(){
            private static final long serialVersionUID = -4779867622071856085L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLogView.this.setPageRunningVisible(true);
                AbstractLogView.this.disableUserActions();
                AbstractLogView.this.logViewListener.onPrevious(AbstractLogView.this.numLinesRequested);
            }
        });
        this.btnPrevious.setToolTipText(STLConstants.K2168_PREVIOUS.getValue());
        this.btnPrevious.setIcon(UIImages.BACK_WHITE_ICON.getImageIcon());
        this.btnPrevious.setName(WidgetName.ADMIN_LOGS_PREVIOUS_BUTTON.name());
        pnlNav.add(this.btnPrevious);
        pnlNav.add(Box.createHorizontalStrut(5));
        this.btnNext = ComponentFactory.getIntelActionButton(new AbstractAction(){
            private static final long serialVersionUID = 905214147006236116L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractLogView.this.setPageRunningVisible(true);
                AbstractLogView.this.disableUserActions();
                AbstractLogView.this.logViewListener.onNext(AbstractLogView.this.numLinesRequested);
            }
        });
        this.btnNext.setToolTipText(STLConstants.K0622_NEXT.getValue());
        this.btnNext.setEnabled(false);
        this.btnNext.setIcon(UIImages.FORWARD_WHITE_ICON.getImageIcon());
        this.btnNext.setName(WidgetName.ADMIN_LOGS_NEXT_BUTTON.name());
        pnlNav.add(this.btnNext);
        this.lblPageRunning = new JLabel();
        this.lblPageRunning.setIcon(UIImages.INVISIBLE.getImageIcon());
        this.lblPageRunning.setName(WidgetName.ADMIN_LOGS_PAGE_RUNNING.name());
        pnlNav.add(this.lblPageRunning);
        return pnlNav;
    }

    public void onEndOfPage() {
        if (!this.txtFldLinesPerPage.isEditValid()) {
            this.txtFldLinesPerPage.requestFocusInWindow();
            return;
        }
        this.numLinesRequested = (Long)this.cboxLinesPerPageValue.getEditor().getItem();
        boolean ok = this.checkNumLines(this.numLinesRequested);
        if (ok) {
            this.disableUserActions();
            this.setRefreshRunningVisible(true);
            this.logViewListener.onLastLines(this.numLinesRequested);
        } else {
            Util.showErrorMessage(this.pnlRefresh, UILabels.STL50213_LINES_PER_PAGE_ERROR.getDescription(this.numLinesRequested, 1L, 1000L));
            this.cboxLinesPerPageValue.setSelectedIndex(this.numLineIndex);
        }
        if (ok && ((DefaultComboBoxModel)this.cboxLinesPerPageValue.getModel()).getIndexOf(this.numLinesRequested) == -1) {
            this.cboxLinesPerPageValue.addItem(this.numLinesRequested);
            this.cboxLinesPerPageValue.setSelectedItem(this.numLinesRequested);
        }
    }

    protected boolean checkNumLines(long numLines) {
        return 1L <= numLines && numLines <= 1000L;
    }

    public void setPageRunningVisible(boolean b) {
        if (b) {
            this.lblPageRunning.setIcon(UIImages.RUNNING.getImageIcon());
        } else {
            this.lblPageRunning.setIcon(UIImages.INVISIBLE.getImageIcon());
        }
    }

    public void setRefreshRunningVisible(boolean b) {
        if (b) {
            this.lblRefreshRunning.setIcon(UIImages.RUNNING.getImageIcon());
        } else {
            this.lblRefreshRunning.setIcon(UIImages.INVISIBLE.getImageIcon());
        }
    }

    public List<FilterType> getSelectedFilters() {
        ArrayList<FilterType> filters = new ArrayList<FilterType>();
        for (JCheckBox chkbox : this.chkboxFilterList) {
            if (!chkbox.isSelected()) continue;
            filters.add(FilterType.getFilter(chkbox.getText()));
        }
        return filters;
    }

    public void updateLogView(final SMLogModel model) {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                AbstractLogView.this.showFileName(model.getLogFilePath());
                AbstractLogView.this.showLogEntry(model.getFilteredDoc());
                AbstractLogView.this.showTotalLines(model);
                AbstractLogView.this.showLineRange(model.getStartLine(), model.getEndLine());
                if (model.getLogMsg() != null) {
                    AbstractLogView.this.logViewListener.onFilter();
                }
                AbstractLogView.this.setPageRunningVisible(false);
                AbstractLogView.this.setRefreshRunningVisible(false);
            }
        });
    }

    public void updateLoginView(SMLogModel model) {
        this.smLoginView.updateView(model);
    }

    public synchronized void setNextEnabled(boolean b) {
        if (this.enableUserActions) {
            this.btnNext.setEnabled(b);
        }
    }

    public synchronized void setPreviousEnabled(boolean b) {
        if (this.enableUserActions) {
            this.btnPrevious.setEnabled(b);
        }
    }

    public void showTotalLines(SMLogModel model) {
        if (this.hasRunningIcon()) {
            this.setNumLineIcon(false);
        }
        this.lblTotalLinesValue.setText(String.valueOf(model.getNumLines()));
    }

    public void showFileName(String fileName) {
        this.lblFileNameValue.setText(fileName);
        this.lblFileNameValue.setToolTipText(fileName);
    }

    public void showLineRange(long startLine, long endLine) {
        if (startLine > 0L && endLine > 0L) {
            this.lblStartLineValue.setText(String.valueOf(startLine));
            this.lblEndLineValue.setText(String.valueOf(endLine));
        }
    }

    public void showNumMatches(long matches) {
        this.lblNumMatchesValue.setText(String.valueOf(matches));
    }

    public long getNumLinesRequested() {
        return this.numLinesRequested;
    }

    public void setLoginListener(ILoginListener listener) {
        this.loginListener = listener;
        this.smLoginView.setListener(listener);
    }

    public void setLogController(ILogController controller) {
        this.logController = controller;
    }

    public void setLogViewListener(ILogViewListener listener) {
        this.logViewListener = listener;
        this.smLoginView.setLoginViewListener(listener);
        this.txtfldSearch.getDocument().addDocumentListener(this.logController.getDocumentListener());
    }

    public void setView(String name) {
        this.cardLayout.show(this, name);
        this.currentCardName = name;
    }

    public boolean isLoginView() {
        return this.currentCardName == LogViewType.LOGIN.getValue();
    }

    public boolean isSmLogView() {
        return this.currentCardName == LogViewType.SM_LOG.getValue();
    }

    public void showLogView() {
        this.smLoginView.showProgress(false);
        this.setView(LogViewType.SM_LOG.getValue());
    }

    public void showLoginView() {
        this.smLoginView.showProgress(false);
        this.setView(LogViewType.LOGIN.getValue());
    }

    public void setLoginEnabled(boolean b) {
        this.smLoginView.setEnabled(b);
    }

    public void showProgress(boolean show) {
        this.smLoginView.showProgress(show);
    }

    public void showError(String message) {
        this.smLoginView.setMessage(message);
    }

    public void showErrorDialog(String message) {
        Util.showErrorMessage(this.smLoginView, message);
    }

    public void clearLoginData() {
        this.smLoginView.clearLoginData();
        this.smLoginView.setMessage("");
        this.smLoginView.repaint();
    }

    public LoginBean getCredentials() {
        return this.smLoginView.getCredentials();
    }

    public String getLogFilePath() {
        return this.smLoginView.getLogFilePath();
    }

    public void setCredentials(LoginBean credentials) {
        this.smLoginView.setHostNameField(credentials.getHostName());
        this.smLoginView.setPortNumber(credentials.getPortNum());
        this.smLoginView.setUserNameField(credentials.getUserName());
    }

    public void setNumLineIcon(boolean b) {
        if (b) {
            this.lblTotalLinesValue.setIcon(UIImages.RUNNING.getImageIcon());
        } else {
            this.lblTotalLinesValue.setIcon(null);
        }
    }

    public boolean hasRunningIcon() {
        return this.lblTotalLinesValue.getIcon() != null;
    }

    public synchronized void disableUserActions() {
        this.enableUserActions = false;
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < AbstractLogView.this.buttons.length; ++i) {
                    ((AbstractLogView)AbstractLogView.this).lastButtonState[i] = AbstractLogView.this.buttons[i].isEnabled();
                    AbstractLogView.this.buttons[i].setEnabled(false);
                }
            }
        });
    }

    public synchronized void restoreUserActions(final boolean isFirstPage, final boolean isLastPage) {
        this.enableUserActions = true;
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < AbstractLogView.this.buttons.length; ++i) {
                    AbstractLogView.this.buttons[i].setEnabled(AbstractLogView.this.lastButtonState[i]);
                }
                AbstractLogView.this.setPreviousEnabled(!isFirstPage);
                AbstractLogView.this.setNextEnabled(!isLastPage);
            }
        });
    }

    public LogConfigType getConfigType() {
        return this.smLoginView.getConfigType().getType();
    }

    abstract Component getMainComponent();

    abstract JTextComponent getTextContent();

    public abstract void showLogEntry(List<String> var1);

    public abstract void highlightText(List<SearchKey> var1, List<SearchPositionBean> var2, SearchState var3);

    public abstract void moveToText(int var1, int var2);
}

