/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.logs;

import com.intel.stl.ui.admin.impl.SMLogModel;
import com.intel.stl.ui.admin.impl.logs.ILogViewListener;
import com.intel.stl.ui.admin.view.LoginPanel;
import com.intel.stl.ui.common.STLConstants;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.console.LoginBean;
import com.intel.stl.ui.model.LogConfigTypeViz;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.swingx.JXLabel;

public class SMLoginView
extends LoginPanel {
    private static final long serialVersionUID = -2884097977886279977L;
    private JLabel lblLogFileName;
    private JFormattedTextField txtfldLogFilePath;
    private JRadioButton rbAutoConfig;
    private JRadioButton rbCustomConfig;
    private ILogViewListener logViewListener;

    public void setLoginViewListener(ILogViewListener listener) {
        this.logViewListener = listener;
    }

    @Override
    protected void initLoginPanel() {
        super.initLoginPanel();
        this.removeAll();
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gc.insets = new Insets(10, 75, 10, 10);
        this.gc.fill = 2;
        this.gc.weightx = 1.0;
        this.gc.gridwidth = 0;
        this.add((Component)this.createMessageArea(), this.gc);
        this.gc.gridx = 0;
        this.gc.gridy = 1;
        this.gc.fill = 2;
        this.gc.anchor = 17;
        this.gc.gridwidth = 0;
        this.gc.insets = new Insets(0, 75, 0, 10);
        this.add((Component)this.createConfigPanel(), this.gc);
        int row = this.addCredentialFields(2);
        this.gc.weightx = 0.1;
        this.gc.gridx = 0;
        this.gc.gridy = row++;
        this.gc.gridwidth = 1;
        this.lblLogFileName = ComponentFactory.getH5Label(STLConstants.K2163_LOG_FILE.getValue() + " :", 1);
        this.lblLogFileName.setHorizontalAlignment(4);
        this.add((Component)this.lblLogFileName, this.gc);
        this.gc.weightx = 0.8;
        this.gc.gridx = 1;
        this.gc.gridwidth = 0;
        this.txtfldLogFilePath = ComponentFactory.createTextField(null, true, 40, null);
        this.txtfldLogFilePath.setText("");
        this.txtfldLogFilePath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyChar() == '\n') {
                    SMLoginView.this.loginBtnAction();
                }
            }
        });
        this.add((Component)this.txtfldLogFilePath, this.gc);
        this.gc.gridx = 1;
        this.gc.gridy = row++;
        this.gc.weightx = 1.0;
        this.gc.fill = 2;
        this.gc.anchor = 10;
        this.gc.gridwidth = 0;
        this.add((Component)this.createProgressBar(), this.gc);
        this.gc.gridx = 1;
        this.gc.gridy = row++;
        this.gc.gridwidth = 0;
        this.gc.fill = 2;
        this.add((Component)this.createButtonPanel(), this.gc);
        this.gc.gridx = 0;
        this.gc.gridy = row;
        this.gc.anchor = 17;
        this.gc.gridwidth = 0;
        this.gc.fill = 2;
        JPanel pnlEsmNote = this.createEsmNotePanel();
        this.add((Component)pnlEsmNote, this.gc);
        this.setPreferredSize(new Dimension(400, 550));
        this.setHostFieldEditable(true);
        this.enableForm(false);
    }

    protected JPanel createEsmNotePanel() {
        JPanel pnlEsmNote = new JPanel(new BorderLayout());
        pnlEsmNote.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_GRAY));
        JXLabel lblEsmNote = new JXLabel(UILabels.STL50219_ESM_SYSLOG_NOTE.getDescription());
        lblEsmNote.setFont(UIConstants.H5_FONT.deriveFont(1));
        lblEsmNote.setForeground(UIConstants.INTEL_BLUE);
        lblEsmNote.setLineWrap(true);
        lblEsmNote.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnlEsmNote.add((Component)lblEsmNote, "Center");
        return pnlEsmNote;
    }

    protected JPanel createConfigPanel() {
        JPanel pnlConfig = new JPanel();
        pnlConfig.setLayout(new BoxLayout(pnlConfig, 0));
        pnlConfig.setBackground(UIConstants.INTEL_WHITE);
        this.rbAutoConfig = new JRadioButton(LogConfigTypeViz.AUTO_CONFIG.getValue());
        this.rbAutoConfig.setOpaque(false);
        this.rbAutoConfig.setFont(UIConstants.H5_FONT);
        this.rbAutoConfig.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.rbAutoConfig.setSelected(true);
        this.rbAutoConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SMLoginView.this.enableForm(false);
                SMLoginView.this.restoreAutoConfigView();
            }
        });
        this.rbCustomConfig = new JRadioButton(LogConfigTypeViz.CUSTOM_CONFIG.getValue());
        this.rbCustomConfig.setOpaque(false);
        this.rbCustomConfig.setFont(UIConstants.H5_FONT);
        this.rbCustomConfig.setForeground(UIConstants.INTEL_DARK_GRAY);
        this.rbCustomConfig.setSelected(false);
        this.rbCustomConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SMLoginView.this.enableForm(true);
            }
        });
        ButtonGroup grpButtons = new ButtonGroup();
        grpButtons.add(this.rbAutoConfig);
        grpButtons.add(this.rbCustomConfig);
        pnlConfig.add(Box.createHorizontalStrut(45));
        pnlConfig.add(this.rbAutoConfig);
        pnlConfig.add(Box.createHorizontalStrut(50));
        pnlConfig.add(this.rbCustomConfig);
        return pnlConfig;
    }

    public void enableForm(boolean b) {
        if (this.rbCustomConfig != null) {
            this.rbCustomConfig.setSelected(b);
        }
        if (this.rbAutoConfig != null) {
            this.rbAutoConfig.setSelected(!b);
        }
        if (this.hostField != null) {
            this.hostField.setEnabled(b);
        }
        if (this.portField != null) {
            this.portField.setEnabled(b);
        }
        if (this.txtfldLogFilePath != null) {
            this.txtfldLogFilePath.setEnabled(b);
        }
    }

    public LogConfigTypeViz getConfigType() {
        return this.rbAutoConfig.isSelected() ? LogConfigTypeViz.AUTO_CONFIG : LogConfigTypeViz.CUSTOM_CONFIG;
    }

    public String getLogFilePath() {
        return this.txtfldLogFilePath.getText();
    }

    @Override
    protected void cancelBtnAction() {
        super.cancelBtnAction();
        this.logViewListener.updateLoginView();
    }

    public void resetLogin() {
        this.clearLoginData();
    }

    public void updateView(SMLogModel model) {
        LoginBean credentials = model.getCredentials();
        this.hostField.setText(credentials.getHostName());
        this.portField.setText(credentials.getPortNum());
        this.userField.setText(credentials.getUserName());
        this.passwordField.setText("");
        this.txtfldLogFilePath.setText(model.getLogFilePath());
        this.enableForm(this.getConfigType().equals((Object)LogConfigTypeViz.CUSTOM_CONFIG));
    }

    protected void restoreAutoConfigView() {
        this.logViewListener.restoreAutoConfigView();
    }
}

