/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.admin.view.virtualfabrics;

import com.intel.stl.api.management.virtualfabrics.HoqLife;
import com.intel.stl.ui.admin.view.AbstractAttrRenderer;
import com.intel.stl.ui.common.view.IntelComboBoxUI;
import com.intel.stl.ui.common.view.SafeNumberField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class HoqLifeRenderer
extends AbstractAttrRenderer<HoqLife> {
    private final JPanel panel = new JPanel(new BorderLayout(5, 5));
    private final SafeNumberField<Integer> field;
    private final JComboBox<HoqLife.TimeOut.Unit> unitBox;

    public HoqLifeRenderer() {
        this.panel.setOpaque(false);
        this.field = new SafeNumberField<Integer>(new DecimalFormat("###"), 1, true);
        this.field.setValidChars("0123456789");
        this.field.setValue(new Integer(1));
        this.panel.add(this.field, "Center");
        this.unitBox = new JComboBox<HoqLife.TimeOut.Unit>(HoqLife.TimeOut.Unit.values());
        IntelComboBoxUI ui = new IntelComboBoxUI(){

            @Override
            protected String getValueString(Object value) {
                return ((HoqLife.TimeOut.Unit)((Object)value)).name().toLowerCase();
            }
        };
        this.unitBox.setUI(ui);
        this.unitBox.setPreferredSize(new Dimension(50, 20));
        this.panel.add(this.unitBox, "East");
    }

    @Override
    public void setAttr(HoqLife attr) {
        HoqLife.TimeOut to = (HoqLife.TimeOut)attr.getObject();
        this.field.setValue(to.getValue());
        this.unitBox.setSelectedItem((Object)to.getUnit());
    }

    @Override
    public void setEditable(boolean isEditable) {
        this.field.setEditable(isEditable);
        this.unitBox.setEnabled(isEditable);
    }

    @Override
    public HoqLife getAttr() {
        int value = ((Number)this.field.getValue()).intValue();
        HoqLife.TimeOut.Unit unit = (HoqLife.TimeOut.Unit)((Object)this.unitBox.getSelectedItem());
        return new HoqLife(new HoqLife.TimeOut(value, unit));
    }

    @Override
    protected Component[] getFields() {
        return new Component[]{this.panel};
    }

    @Override
    public boolean isEditValid() {
        return this.field.isEditValid();
    }
}

