/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.alert;

import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.IEventListener;
import com.intel.stl.ui.alert.INotifyRule;
import com.intel.stl.ui.main.Context;
import java.util.ArrayList;
import java.util.List;

public abstract class NoticeNotifier
implements IEventListener<EventDescription> {
    protected final Context context;
    private final List<INotifyRule> rules = new ArrayList<INotifyRule>();

    public NoticeNotifier(Context context, List<INotifyRule> rules) {
        this.context = context;
        this.setRules(rules);
    }

    public synchronized void addRule(INotifyRule rule) {
        if (rule != null) {
            this.rules.add(rule);
        }
    }

    public synchronized void removeRule(INotifyRule rule) {
        if (rule != null) {
            this.rules.remove(rule);
        }
    }

    public synchronized void setRules(List<INotifyRule> rules) {
        if (rules != null) {
            this.rules.clear();
            this.rules.addAll(rules);
        }
    }

    public synchronized List<INotifyRule> getRules() {
        return this.rules;
    }

    public void onNewEvent(EventDescription[] data) {
        ArrayList<EventDescription> toSend = new ArrayList<EventDescription>();
        for (EventDescription event : data) {
            if (!this.shouldNotify(event)) continue;
            toSend.add(event);
        }
        if (!toSend.isEmpty()) {
            this.notify(toSend);
        }
    }

    protected synchronized boolean shouldNotify(EventDescription event) {
        for (INotifyRule rule : this.rules) {
            if (!rule.match(event)) continue;
            return true;
        }
        return false;
    }

    protected abstract void notify(List<EventDescription> var1);
}

