/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.api.notice.EventDescription;
import com.intel.stl.api.notice.IEventListener;
import com.intel.stl.api.notice.INoticeApi;
import com.intel.stl.ui.common.EventTableModel;
import com.intel.stl.ui.common.IContextAware;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.PageWeight;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.FVTableView;
import com.intel.stl.ui.main.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTableController
implements IEventListener<EventDescription>,
IContextAware {
    private static final String NAME = "EventTable";
    EventTableModel mEvtTblModel;
    FVTableView mEvtTblView;
    private static Logger mLog = LoggerFactory.getLogger(EventTableController.class);
    private INoticeApi noticeApi;

    public EventTableController(EventTableModel pEvtTblModel, FVTableView pEvtTblView) {
        this.mEvtTblModel = pEvtTblModel;
        this.mEvtTblView = pEvtTblView;
    }

    public boolean addEvent(final EventDescription event) {
        mLog.debug("Event type: {}; event severity: {}", (Object)event.getType(), (Object)event.getSeverity());
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                EventTableController.this.mEvtTblModel.addEntry(event);
                EventTableController.this.mEvtTblModel.fireTableDataChanged();
            }
        });
        return true;
    }

    public void clear() {
        Util.runInEDT(new Runnable(){

            @Override
            public void run() {
                EventTableController.this.mEvtTblModel.clear();
                EventTableController.this.mEvtTblModel.fireTableDataChanged();
            }
        });
    }

    @Override
    public void setContext(Context context, IProgressObserver observer) {
        if (this.noticeApi != null) {
            this.noticeApi.removeEventListener(this);
        }
        this.noticeApi = context.getNoticeApi();
        this.noticeApi.addEventListener(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public void onNewEvent(EventDescription[] eventList) {
        for (EventDescription event : eventList) {
            this.addEvent(event);
        }
    }

    @Override
    public PageWeight getContextSwitchWeight() {
        return PageWeight.LOW;
    }

    @Override
    public PageWeight getRefreshWeight() {
        return PageWeight.LOW;
    }
}

