/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import com.intel.stl.ui.common.BaseCardController;
import com.intel.stl.ui.common.IPinCard;
import com.intel.stl.ui.common.IPinProvider;
import com.intel.stl.ui.common.PinDescription;
import com.intel.stl.ui.common.view.ICardListener;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.framework.IAppEvent;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.PinBoardController;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Properties;
import javax.swing.JComponent;
import net.engio.mbassy.bus.MBassador;

public abstract class PinnableCardController<E extends ICardListener, V extends JCardView<E>>
extends BaseCardController<E, V>
implements IPinProvider {
    protected PinBoardController pinBoardCtr;
    protected V pinView;

    public PinnableCardController(V view, MBassador<IAppEvent> eventBus) {
        super(view, eventBus);
    }

    public void setContext(Context context) {
        if (context == null) {
            return;
        }
        PinBoardController ctr = context.getController().getPinBoardController();
        if (this.pinBoardCtr != ctr) {
            if (this.pinBoardCtr != null) {
                this.pinBoardCtr.deregisterPinProvider(this.getPinID());
            } else {
                this.view.enablePin(true);
            }
            this.pinBoardCtr = ctr;
            this.pinBoardCtr.registerPinProvider(this.getPinID(), this);
        }
    }

    @Override
    public void onPin() {
        if (this.pinBoardCtr != null) {
            PinDescription pin = new PinDescription(this.getPinID(), this.view.getTitle());
            this.generateArgument(pin.getArgument());
            this.pinBoardCtr.addPin(pin);
        }
    }

    protected abstract void generateArgument(Properties var1);

    @Override
    public IPinCard createPin(PinDescription pin) {
        if (pin.getID() != this.getPinID()) {
            throw new IllegalArgumentException("Unmatched PinID. Expect " + (Object)((Object)this.getPinID()) + ", got " + (Object)((Object)pin.getID()));
        }
        this.view.enablePin(false);
        return this.createPinCard(pin);
    }

    protected IPinCard createPinCard(final PinDescription pin) {
        return new IPinCard(){

            @Override
            public PinDescription getDescription() {
                return pin;
            }

            @Override
            public Component getView() {
                PinnableCardController.this.pinView = PinnableCardController.this.createPinView();
                PinnableCardController.this.initPinView();
                JComponent comp = ((JCardView)PinnableCardController.this.pinView).getContentComponent();
                Dimension size = PinnableCardController.this.view.getContentComponent().getSize();
                int height = pin.getHeight();
                if (height > 0) {
                    ((Component)comp).setPreferredSize(new Dimension(size.width, height));
                } else {
                    ((Component)comp).setPreferredSize(size);
                    pin.setHeight(size.height);
                }
                return comp;
            }

            @Override
            public void unpin() {
                PinnableCardController.this.clearPinView();
                PinnableCardController.this.view.enablePin(true);
            }
        };
    }

    protected abstract V createPinView();

    protected abstract void initPinView();

    protected void clearPinView() {
        this.pinView = null;
    }

    @Override
    public abstract PinDescription.PinID getPinID();
}

