/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common;

import java.beans.PropertyChangeSupport;

public class TimeDrivenProgressObserver {
    private final PropertyChangeSupport support;
    private final int totalNodeCount;
    private double doneWork;
    private int progressToPublish;
    private long lastTimePublished;
    private final long publishInterval = 500L;

    public TimeDrivenProgressObserver(PropertyChangeSupport support, int totalNodeCount) {
        this.support = support;
        this.totalNodeCount = totalNodeCount;
    }

    public void publishProgress(int deltaProgress) {
        this.doneWork += (double)deltaProgress;
        this.progressToPublish += deltaProgress;
        if (this.isTimeToPublish() || this.progressToPublish == this.totalNodeCount) {
            this.support.firePropertyChange("ProgressAmount", null, new Double(this.doneWork));
            this.doneWork = 0.0;
        }
    }

    private boolean isTimeToPublish() {
        long currentTime = System.currentTimeMillis();
        long interval = currentTime - this.lastTimePublished;
        if (interval >= 500L) {
            this.lastTimePublished = currentTime;
            return true;
        }
        return false;
    }

    public void publishNote(String note) {
        this.support.firePropertyChange("ProgressNote", null, note);
    }
}

