/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.common.view.ComponentFactory;
import com.intel.stl.ui.common.view.IChartCreator;
import com.intel.stl.ui.common.view.IChartsCardListener;
import com.intel.stl.ui.common.view.IntelComboBoxUI;
import com.intel.stl.ui.common.view.JCardView;
import com.intel.stl.ui.common.view.JumpChartPanel;
import com.intel.stl.ui.model.DatasetDescription;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;

public class ChartsView
extends JCardView<IChartsCardListener> {
    private static final long serialVersionUID = -2134542205733463526L;
    private JPanel ctrPanel;
    private JComboBox<DatasetDescription> chartList;
    private ActionListener chartListListener;
    private JPanel mainPanel;
    private final IChartCreator chartCreator;
    private JumpChartPanel chartPanel;
    private Map<String, ChartWrap> charts;

    public ChartsView(String title, IChartCreator chartCreator) {
        super(title);
        this.setPreferredSize(new Dimension(270, 250));
        this.chartCreator = chartCreator;
    }

    @Override
    protected JComponent getExtraComponent() {
        if (this.ctrPanel == null) {
            this.ctrPanel = new JPanel(new FlowLayout(0, 1, 1));
        }
        return this.ctrPanel;
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout(0, 0));
            this.mainPanel.setOpaque(false);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.chartPanel = new JumpChartPanel(null);
            this.chartPanel.setOpaque(false);
            this.chartPanel.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ChartsView.this.chartPanel.setMaximumDrawHeight(e.getComponent().getHeight());
                    ChartsView.this.chartPanel.setMaximumDrawWidth(e.getComponent().getWidth());
                    ChartsView.this.chartPanel.setMinimumDrawWidth(e.getComponent().getWidth());
                    ChartsView.this.chartPanel.setMinimumDrawHeight(e.getComponent().getHeight());
                }
            });
            this.mainPanel.add((Component)((Object)this.chartPanel), "Center");
        }
        return this.mainPanel;
    }

    public void setMainPanelName(String name) {
        if (null != this.mainPanel) {
            this.mainPanel.setName(name);
        }
    }

    public void setDatasets(List<DatasetDescription> datasets) {
        this.setChartNames(datasets);
        this.charts = new HashMap<String, ChartWrap>();
        if (datasets != null) {
            for (DatasetDescription dd : datasets) {
                String name = dd.getName();
                Dataset dataset = dd.getDataset();
                this.charts.put(name, new ChartWrap(this.chartCreator.createChart(dd.getFullName(), dataset), dd.isJumpable()));
            }
        }
    }

    protected void setChartNames(List<DatasetDescription> datasets) {
        if (this.ctrPanel == null) {
            throw new RuntimeException("Something weird happend! chartPanel is null");
        }
        if (datasets == null || datasets.isEmpty()) {
            return;
        }
        if (datasets.size() == 1) {
            DatasetDescription dd = datasets.get(0);
            this.setTitle(dd.getName(), dd.getFullName());
        } else {
            this.setTitle(null);
            this.chartList = new JComboBox<DatasetDescription>(datasets.toArray(new DatasetDescription[0]));
            IntelComboBoxUI ui = new IntelComboBoxUI(){

                @Override
                protected String getValueString(Object value) {
                    return ((DatasetDescription)value).getName();
                }

                @Override
                protected String getValueTooltip(Object value) {
                    return ((DatasetDescription)value).getFullName();
                }
            };
            ui.setEditorBorder(BorderFactory.createEmptyBorder());
            ui.setArrowButtonTooltip(UILabels.STL10103_MORE_SELECTIONS.getDescription());
            ui.setArrowButtonBorder(null);
            this.chartList.setUI(ui);
            this.setListListener();
            this.ctrPanel.add(this.chartList);
        }
    }

    @Override
    public void setCardListener(IChartsCardListener listener) {
        if (this.chartPanel == null) {
            throw new RuntimeException("Something weird happend! chartPanel is null");
        }
        IChartsCardListener oldListener = (IChartsCardListener)this.listener;
        super.setCardListener(listener);
        this.setListListener();
        if (oldListener != null) {
            this.chartPanel.removeListener(oldListener);
        }
        if (listener != null) {
            this.chartPanel.addListener(listener);
        }
    }

    protected void setListListener() {
        if (this.chartList == null || this.listener == null) {
            return;
        }
        if (this.chartListListener != null) {
            this.chartList.removeActionListener(this.chartListListener);
        }
        this.chartListListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetDescription dd = (DatasetDescription)ChartsView.this.chartList.getSelectedItem();
                ((IChartsCardListener)ChartsView.this.listener).onSelectChart(dd.getName());
            }
        };
        this.chartList.addActionListener(this.chartListListener);
    }

    public void setChart(String name) {
        if (this.chartPanel == null) {
            throw new RuntimeException("Something weird happend! chartPanel is null");
        }
        ChartWrap cw = this.getChartWrap(name);
        this.chartPanel.setChart(cw.chart, cw.isJumpable);
        super.enablePin(cw.isPinnable());
        this.validate();
    }

    public void selectChart(String name) {
        DatasetDescription dd;
        if (this.chartList != null && !(dd = (DatasetDescription)this.chartList.getSelectedItem()).getName().equals(name)) {
            int index = this.indexOf(name);
            if (index >= 0) {
                this.chartList.setSelectedIndex(index);
            }
            return;
        }
    }

    protected int indexOf(String name) {
        for (int i = 0; i < this.chartList.getItemCount(); ++i) {
            DatasetDescription dd = this.chartList.getItemAt(i);
            if (!dd.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public JFreeChart getChart(String name) {
        return this.getChartWrap((String)name).chart;
    }

    @Override
    public void enablePin(boolean b) {
        for (ChartWrap cw : this.charts.values()) {
            cw.setPinnable(b);
        }
        super.enablePin(b);
    }

    public void enablePin(String name, boolean b) {
        ChartWrap cw = this.getChartWrap(name);
        if (this.chartPanel.getChart() == cw.getChart()) {
            super.enablePin(b);
        }
        cw.setPinnable(b);
    }

    public JFreeChart getSparkline(String name) {
        if (this.charts == null) {
            return null;
        }
        JFreeChart chart = this.getChartWrap((String)name).chart;
        if (chart == null) {
            return null;
        }
        XYPlot plot = chart.getXYPlot();
        if (plot == null) {
            return null;
        }
        int count = plot.getDatasetCount();
        if (count == 3) {
            return ComponentFactory.createUtilXYTrendSparkline((IntervalXYDataset)plot.getDataset(0), plot.getDataset(1), plot.getDataset(2));
        }
        XYDataset dataset = plot.getDataset();
        return ComponentFactory.createXYTrendSparkline((IntervalXYDataset)dataset);
    }

    protected ChartWrap getChartWrap(String name) {
        ChartWrap res = this.charts.get(name);
        if (res != null) {
            return res;
        }
        throw new IllegalArgumentException("Couldn't find chart '" + name + "'");
    }

    private class ChartWrap {
        JFreeChart chart;
        boolean isJumpable;
        boolean isPinnable;

        public ChartWrap(JFreeChart chart, boolean isJumpable) {
            this.chart = chart;
            this.isJumpable = isJumpable;
        }

        public JFreeChart getChart() {
            return this.chart;
        }

        public boolean isPinnable() {
            return this.isPinnable;
        }

        public void setPinnable(boolean isPinnable) {
            this.isPinnable = isPinnable;
        }
    }
}

