/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class DistributionBarPanel
extends JPanel {
    private static final long serialVersionUID = 5519998835959335916L;
    private long[] cumulativeSum;
    private Color[] colors;
    private final int barHeight = 8;
    private JLabel[] labels;

    public DistributionBarPanel() {
        this.setLayout(new FlowLayout(2, 4, 0));
    }

    public void init(String[] itemLabels, ImageIcon[] icons) {
        if (itemLabels.length != icons.length) {
            throw new IllegalArgumentException("Inconsistent array size. itemLabels=" + itemLabels.length + " icons=" + icons.length);
        }
        this.labels = new JLabel[itemLabels.length];
        for (int i = 0; i < itemLabels.length; ++i) {
            this.labels[i] = new JLabel(itemLabels[i], icons[i], 2);
            this.labels[i].setVerticalAlignment(3);
            this.add(this.labels[i]);
        }
    }

    @Override
    public void setBorder(Border border) {
        CompoundBorder newBorder = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(16, 0, 0, 0));
        super.setBorder(newBorder);
    }

    public void update(String[] newLabels, long[] cumulativeSum, Color[] colors) {
        if (newLabels.length != this.labels.length) {
            throw new IllegalArgumentException("Incorrect number of newLabels. Expected " + this.labels.length + " items, got " + newLabels.length + " items");
        }
        if (cumulativeSum.length != this.labels.length) {
            throw new IllegalArgumentException("Incorrect number of cumulativeSum. Expected " + this.labels.length + " items, got " + cumulativeSum.length + " items");
        }
        if (colors.length != this.labels.length) {
            throw new IllegalArgumentException("Incorrect number of newLabels. Expected " + this.labels.length + " items, got " + colors.length + " items");
        }
        this.cumulativeSum = cumulativeSum;
        this.colors = colors;
        for (int i = 0; i < colors.length; ++i) {
            this.labels[i].setText(newLabels[i]);
        }
        this.repaint();
        this.validate();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension res = super.getPreferredSize();
        res.height += 8;
        return res;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.cumulativeSum == null) {
            return;
        }
        Insets insets = this.getInsets();
        int width = this.getWidth() - insets.left - insets.right;
        int x = insets.left;
        int y = Math.max(insets.top - 8 - 2, 0);
        int nextX = 0;
        double scale = (double)width / (double)this.cumulativeSum[this.cumulativeSum.length - 1];
        for (int i = 0; i < this.cumulativeSum.length; ++i) {
            x = nextX;
            nextX = (int)((double)this.cumulativeSum[i] * scale);
            g.setColor(this.colors[i]);
            g.fillRect(x, y, nextX - x, 8);
        }
    }
}

