/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.api.configuration.EventType;
import com.intel.stl.api.notice.NoticeSeverity;
import com.intel.stl.ui.common.EventTableModel;
import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import com.intel.stl.ui.common.view.FVHeaderRenderer;
import com.intel.stl.ui.common.view.FVTableRenderer;
import com.intel.stl.ui.common.view.FVTableView;
import com.intel.stl.ui.model.EventTypeViz;
import com.intel.stl.ui.model.NoticeSeverityViz;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.ScrollPaneLayout;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class EventTableView
extends FVTableView {
    private static final long serialVersionUID = 3269064546124145702L;

    public EventTableView(EventTableModel pModel) {
        this.initComponents();
        this.setModel(pModel);
        this.formatTable();
    }

    @Override
    public void formatTable() {
        FVTableRenderer tableRenderer = new FVTableRenderer(){
            private static final long serialVersionUID = -5458310374933530865L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel cell = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 1 && value != null) {
                    NoticeSeverityViz nsv = NoticeSeverityViz.getNoticeSeverityVizFor((NoticeSeverity)((Object)value));
                    if (nsv != null) {
                        cell.setText(nsv.getName());
                        cell.setForeground(nsv.getColor());
                    }
                    cell.setFont(UIConstants.H5_FONT.deriveFont(1));
                } else {
                    if (column == 3 && value != null) {
                        EventTypeViz ntv = EventTypeViz.getEventTypeVizFor((EventType)((Object)value));
                        if (ntv != null) {
                            cell.setText(ntv.getName());
                        }
                    } else if (column == 0 && value != null) {
                        String timeStr = Util.getYYYYMMDDHHMMSS().format(value);
                        cell.setText(timeStr);
                    }
                    cell.setForeground(UIConstants.INTEL_DARK_GRAY);
                    cell.setIcon(null);
                }
                return cell;
            }
        };
        FVHeaderRenderer headerRenderer = new FVHeaderRenderer(this.mTable);
        this.mHeaderCol = this.mTable.getTableHeader();
        this.mHeaderCol.setFont(UIConstants.H3_FONT.deriveFont(1));
        for (int i = 0; i < this.mTable.getColumnCount(); ++i) {
            this.mTable.getColumnModel().getColumn(i).setHeaderRenderer(headerRenderer);
            this.mTblCol = this.mTable.getColumnModel().getColumn(i);
            this.mTblCol.setCellRenderer(tableRenderer);
        }
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.mTable.getModel());
        this.mTable.setRowSorter(sorter);
        List<RowSorter.SortKey> sortKeys = Collections.singletonList(new RowSorter.SortKey(0, SortOrder.DESCENDING));
        sorter.setSortKeys(sortKeys);
    }

    public void initComponents() {
        this.mTable = new JTable();
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setPreferredScrollableViewportSize(this.getMaximumSize());
        this.mTable.setAutoCreateColumnsFromModel(true);
        this.mTable.setAutoResizeMode(4);
        this.mTable.setAlignmentX(0.0f);
        this.mTable.setBackground(UIConstants.INTEL_WHITE);
        this.mTable.setIntercellSpacing(new Dimension(2, 3));
        this.mTable.getTableHeader().setReorderingAllowed(false);
        ScrollPaneLayout spLayout = new ScrollPaneLayout();
        spLayout.setHorizontalScrollBarPolicy(32);
        spLayout.setVerticalScrollBarPolicy(22);
        this.mScrollPane = new JScrollPane(this.mTable);
        this.mScrollPane.setPreferredSize(new Dimension(500, 250));
        this.mScrollPane.createHorizontalScrollBar();
        this.mScrollPane.createVerticalScrollBar();
        this.mScrollPane.setLayout(spLayout);
        GridBagLayout gbLayout = new GridBagLayout();
        gbLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbcMainPanel = new GridBagConstraints();
        gbcMainPanel.fill = 1;
        gbcMainPanel.weightx = 1.0;
        gbcMainPanel.weighty = 1.0;
        gbcMainPanel.gridwidth = 0;
        this.add((Component)this.mScrollPane, gbcMainPanel);
    }
}

