/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.ExComboBoxModel;
import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;

public class ExComboBox<E>
extends JComboBox<E> {
    private static final long serialVersionUID = 7774901357006599064L;
    private ExComboBoxModel<E> model;
    private Color disabledColor;

    public ExComboBox() {
        super.setRenderer(new DisabledItemsRenderer());
    }

    public ExComboBox(ExComboBoxModel<E> aModel) {
        super(aModel);
        super.setRenderer(new DisabledItemsRenderer());
    }

    public ExComboBox(E[] items) {
        this(new ExComboBoxModel<E>(items, true));
    }

    public ExComboBox(Vector<E> items) {
        this(new ExComboBoxModel<E>(items, true));
    }

    @Override
    public void setModel(ComboBoxModel<E> aModel) {
        if (!(aModel instanceof ExComboBoxModel)) {
            throw new IllegalArgumentException("Model must be a " + ExComboBoxModel.class.getSimpleName() + " model!");
        }
        this.model = (ExComboBoxModel)aModel;
        super.setModel(aModel);
    }

    public void setDisabledColor(Color disabledColor) {
        this.disabledColor = disabledColor;
    }

    @Override
    public void setSelectedIndex(int index) {
        if (!this.model.isDisabled(index)) {
            super.setSelectedIndex(index);
        }
    }

    protected void decorateDisabledCell(JLabel label, boolean isDisabled, int index) {
        if (isDisabled) {
            if (this.disabledColor != null) {
                label.setForeground(this.disabledColor);
            } else {
                label.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
        }
    }

    private class DisabledItemsRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -5395462996710992524L;

        private DisabledItemsRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ExComboBox.this.decorateDisabledCell(label, ExComboBox.this.model.isDisabled(index), index);
            return label;
        }
    }
}

