/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.UIConstants;
import com.intel.stl.ui.common.Util;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class ExFormattedTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 6265122315036017331L;
    private Border orgBorder;
    private String orgTooltip;
    private String validationTooltip;

    public ExFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
        this.init();
    }

    public ExFormattedTextField(Format format) {
        super(format);
        this.init();
    }

    protected void init() {
        JFormattedTextField.AbstractFormatter formatter = this.getFormatter();
        if (formatter != null && formatter instanceof DefaultFormatter) {
            ((DefaultFormatter)formatter).setOverwriteMode(false);
        }
        this.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JFormattedTextField ftf = (JFormattedTextField)input;
                return ftf.isEditValid();
            }
        });
        this.addPropertyChangeListener("editValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    ExFormattedTextField.this.setBackground(UIConstants.INTEL_WHITE);
                    ExFormattedTextField.this.setBorder(ExFormattedTextField.this.orgBorder);
                    ExFormattedTextField.this.setToolTipText(ExFormattedTextField.this.orgTooltip);
                } else {
                    ExFormattedTextField.this.setBackground(UIConstants.INTEL_LIGHT_RED);
                    if (ExFormattedTextField.this.orgBorder == null) {
                        ExFormattedTextField.this.orgBorder = ExFormattedTextField.this.getBorder();
                    }
                    ExFormattedTextField.this.setBorder(BorderFactory.createLineBorder(UIConstants.INTEL_RED, 2));
                    if (ExFormattedTextField.this.validationTooltip != null) {
                        if (ExFormattedTextField.this.orgTooltip == null) {
                            ExFormattedTextField.this.orgTooltip = ExFormattedTextField.this.getToolTipText();
                        }
                        ExFormattedTextField.this.setToolTipText(ExFormattedTextField.this.validationTooltip);
                        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(ExFormattedTextField.this, 0, 0L, 0, 0, 0, 0, false));
                    }
                }
            }
        });
        Util.makeUndoable(this);
    }

    public void setValidationTooltip(String validationTooltip) {
        this.validationTooltip = validationTooltip;
    }

    public void setFixedFormatter(JFormattedTextField.AbstractFormatter formatter) {
        this.setFormatterFactory(new DefaultFormatterFactory(formatter));
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (!b) {
            this.setBackground(UIConstants.INTEL_BACKGROUND_GRAY);
        } else {
            this.setBackground(UIConstants.INTEL_WHITE);
        }
    }
}

