/*
 * Decompiled with CFR 0.152.
 */
package com.intel.stl.ui.common.view;

import com.intel.stl.ui.common.view.HexField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GIDField
extends JPanel {
    private static final long serialVersionUID = 7780981211073008225L;
    private final String name;
    private HexField<Long> lowerField;
    private HexField<Long> upperField;

    public GIDField(String name) {
        this.name = name;
        this.setName(name);
        this.initComponent();
        this.setValue(0L, 0L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void initComponent() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.fill = 2;
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        JLabel label = new JLabel(this.name);
        this.add((Component)label, gc);
        gc.weightx = 1.0;
        this.lowerField = new HexField<Long>(null, 0L);
        this.add(this.lowerField, gc);
        gc.weightx = 0.0;
        label = new JLabel(":");
        this.add((Component)label, gc);
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        this.upperField = new HexField<Long>(null, 0L);
        this.add(this.upperField, gc);
    }

    public void setValue(long lower, long upper) {
        this.lowerField.setValue(lower);
        this.upperField.setValue(upper);
    }

    public long[] getValue() {
        long[] res = new long[]{this.lowerField.getValue(), this.upperField.getValue()};
        return res;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.lowerField.setEnabled(enabled);
        this.upperField.setEnabled(enabled);
    }

    public void setEditable(boolean b) {
        this.lowerField.setEditable(b);
        this.upperField.setEditable(b);
    }

    public boolean isEditValid() {
        return this.lowerField.isEditValid() && this.upperField.isEditValid();
    }
}

